/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.object.pair.touching;

import java.util.Optional;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.FeatureCalculationInput;
import org.anchoranalysis.feature.calculate.part.CalculationPart;
import org.anchoranalysis.image.feature.bean.object.pair.FeaturePairObjects;
import org.anchoranalysis.image.feature.input.FeatureInputPairObjects;
import org.anchoranalysis.image.voxel.kernel.KernelApplicationParameters;
import org.anchoranalysis.image.voxel.kernel.OutsideKernelPolicy;
import org.anchoranalysis.image.voxel.kernel.count.CountKernel;
import org.anchoranalysis.image.voxel.kernel.count.CountKernelNeighborhoodMask;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.feature.bean.object.pair.touching.CalculateIntersectionOfDilatedBoundingBox;
import org.anchoranalysis.spatial.box.BoundingBox;

public abstract class TouchingVoxels
extends FeaturePairObjects {
    @BeanField
    private boolean do3D = true;

    public double calculate(FeatureCalculationInput<FeatureInputPairObjects> input) throws FeatureCalculationException {
        FeatureInputPairObjects inputSessionless = (FeatureInputPairObjects)input.get();
        Optional<BoundingBox> boxIntersect = this.boxIntersectDilated(input);
        if (!boxIntersect.isPresent()) {
            return 0.0;
        }
        return this.calculateWithIntersection(inputSessionless.getFirst(), inputSessionless.getSecond(), boxIntersect.get());
    }

    protected abstract double calculateWithIntersection(ObjectMask var1, ObjectMask var2, BoundingBox var3) throws FeatureCalculationException;

    protected CountKernel createCountKernelMask(ObjectMask object2Relative) {
        return new CountKernelNeighborhoodMask(object2Relative);
    }

    protected KernelApplicationParameters createParameters() {
        return new KernelApplicationParameters(OutsideKernelPolicy.AS_OFF, this.do3D);
    }

    private Optional<BoundingBox> boxIntersectDilated(FeatureCalculationInput<FeatureInputPairObjects> input) throws FeatureCalculationException {
        return (Optional)input.calculate((CalculationPart)new CalculateIntersectionOfDilatedBoundingBox(this.do3D));
    }

    public boolean isDo3D() {
        return this.do3D;
    }

    public void setDo3D(boolean do3D) {
        this.do3D = do3D;
    }
}

