/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.object.single;

import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.functional.checked.CheckedSupplier;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.FeatureCalculationInput;
import org.anchoranalysis.feature.energy.EnergyStack;
import org.anchoranalysis.image.feature.bean.object.single.FeatureSingleObject;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.image.voxel.kernel.KernelApplicationParameters;
import org.anchoranalysis.image.voxel.kernel.OutsideKernelPolicy;
import org.anchoranalysis.image.voxel.object.ObjectMask;

public abstract class OutlineKernelBase
extends FeatureSingleObject {
    @BeanField
    private boolean outsideAtThreshold = false;
    @BeanField
    private boolean ignoreAtThreshold = false;
    @BeanField
    private boolean do3D = false;

    protected double calculate(FeatureCalculationInput<FeatureInputSingleObject> input) throws FeatureCalculationException {
        FeatureInputSingleObject inputSessionless = (FeatureInputSingleObject)input.get();
        return this.calculateWithParameters(inputSessionless.getObject(), this.createParameters(), (CheckedSupplier<EnergyStack, FeatureCalculationException>)((CheckedSupplier)() -> ((FeatureInputSingleObject)inputSessionless).getEnergyStackRequired()));
    }

    protected abstract double calculateWithParameters(ObjectMask var1, KernelApplicationParameters var2, CheckedSupplier<EnergyStack, FeatureCalculationException> var3) throws FeatureCalculationException;

    private KernelApplicationParameters createParameters() {
        return new KernelApplicationParameters(OutsideKernelPolicy.of((boolean)this.ignoreAtThreshold, (boolean)this.outsideAtThreshold), this.do3D);
    }

    public boolean isOutsideAtThreshold() {
        return this.outsideAtThreshold;
    }

    public void setOutsideAtThreshold(boolean outsideAtThreshold) {
        this.outsideAtThreshold = outsideAtThreshold;
    }

    public boolean isIgnoreAtThreshold() {
        return this.ignoreAtThreshold;
    }

    public void setIgnoreAtThreshold(boolean ignoreAtThreshold) {
        this.ignoreAtThreshold = ignoreAtThreshold;
    }

    public boolean isDo3D() {
        return this.do3D;
    }

    public void setDo3D(boolean do3D) {
        this.do3D = do3D;
    }
}

