/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.object.single.energy;

import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.functional.checked.CheckedSupplier;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.energy.EnergyStack;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.binary.BinaryVoxelsFactory;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.datatype.IncorrectVoxelTypeException;
import org.anchoranalysis.image.voxel.kernel.ApplyKernel;
import org.anchoranalysis.image.voxel.kernel.BinaryKernel;
import org.anchoranalysis.image.voxel.kernel.KernelApplicationParameters;
import org.anchoranalysis.image.voxel.kernel.outline.OutlineKernelNeighborMatchValue;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.feature.bean.object.single.OutlineKernelBase;

public class NumberNeighboringVoxels
extends OutlineKernelBase {
    @BeanField
    private int energyIndex = 0;

    @Override
    protected double calculateWithParameters(ObjectMask object, KernelApplicationParameters parameters, CheckedSupplier<EnergyStack, FeatureCalculationException> energyStack) throws FeatureCalculationException {
        Channel channel = ((EnergyStack)energyStack.get()).getChannel(this.energyIndex);
        OutlineKernelNeighborMatchValue kernelMatch = new OutlineKernelNeighborMatchValue(this.binaryVoxels(channel));
        return ApplyKernel.applyForCount((BinaryKernel)kernelMatch, (BinaryVoxels)object.binaryVoxels(), (KernelApplicationParameters)parameters);
    }

    private BinaryVoxels<UnsignedByteBuffer> binaryVoxels(Channel channel) throws FeatureCalculationException {
        try {
            return BinaryVoxelsFactory.reuseByte((Voxels)channel.voxels().asByte());
        }
        catch (IncorrectVoxelTypeException e) {
            throw new FeatureCalculationException(String.format("energyStack channel %d has incorrect data type", this.getEnergyIndex()), (Throwable)e);
        }
    }

    public int getEnergyIndex() {
        return this.energyIndex;
    }

    public void setEnergyIndex(int energyIndex) {
        this.energyIndex = energyIndex;
    }
}

