/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.object.single.intensity;

import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.object.HistogramFromObjectsFactory;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.math.histogram.Histogram;
import org.anchoranalysis.plugin.image.feature.bean.object.single.intensity.ValueAndIndex;
import org.anchoranalysis.plugin.image.intensity.IntensityMeanCalculator;

class StatsHelper {
    public static ValueAndIndex calculateMaxSliceMean(Channel channel, ObjectMask object, boolean excludeZero) throws FeatureCalculationException {
        double max = Double.NEGATIVE_INFINITY;
        int index = -1;
        for (int z = 0; z < object.boundingBox().extent().z(); ++z) {
            double mean;
            int zTarget = z + object.boundingBox().cornerMin().z();
            ObjectMask slice = object.extractSlice(zTarget, true);
            if (!slice.voxelsOn().anyExists() || !((mean = IntensityMeanCalculator.calculateMeanIntensityObject((Channel)channel, (ObjectMask)slice, (boolean)excludeZero)) > max)) continue;
            index = z;
            max = mean;
        }
        return new ValueAndIndex(max, index);
    }

    public static double calculateMeanNumberVoxels(Channel channel, ObjectMask object, int numberVoxels, boolean highest) throws OperationFailedException {
        Histogram histogram = HistogramFromObjectsFactory.createFrom((Channel)channel, (ObjectMask)object);
        Histogram histogramCut = highest ? histogram.cropRemoveSmallerValues((long)numberVoxels) : histogram.cropRemoveLargerValues((long)numberVoxels);
        return histogramCut.mean();
    }

    private StatsHelper() {
    }
}

