/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.object.single.intensity.gradient;

import java.util.List;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.FeatureCalculationInput;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.plugin.image.feature.bean.object.single.intensity.gradient.IntensityGradientBase;
import org.anchoranalysis.spatial.axis.Axis;
import org.anchoranalysis.spatial.axis.AxisConversionException;
import org.anchoranalysis.spatial.axis.AxisConverter;

public class GradientMeanForAxis
extends IntensityGradientBase {
    @BeanField
    private String axis = "";

    public double calculate(FeatureCalculationInput<FeatureInputSingleObject> input) throws FeatureCalculationException {
        try {
            Axis axisObj = AxisConverter.createFromString((String)this.axis);
            List points = (List)input.calculate(this.gradientCalculation());
            double sum = points.stream().mapToDouble(point -> point.valueByDimension(axisObj)).sum();
            return sum / (double)points.size();
        }
        catch (AxisConversionException e) {
            throw new FeatureCalculationException(e.friendlyMessageHierarchy());
        }
    }

    public String getAxis() {
        return this.axis;
    }

    public void setAxis(String axis) {
        this.axis = axis;
    }
}

