/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.object.single.moments;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import java.util.List;
import org.anchoranalysis.feature.calculate.part.CalculationPart;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.math.statistics.moment.ImageMoments;
import org.anchoranalysis.spatial.point.Point3i;

class CalculateSecondMoments
extends CalculationPart<ImageMoments, FeatureInputSingleObject> {
    private final boolean suppressZ;

    protected ImageMoments execute(FeatureInputSingleObject input) {
        return new ImageMoments(CalculateSecondMoments.createPointMatrixFromObject(input.getObject()), this.suppressZ, false);
    }

    private static DoubleMatrix2D createPointMatrixFromObject(ObjectMask object) {
        return CalculateSecondMoments.createPointMatrixInteger(object.derivePointsLocal());
    }

    private static DoubleMatrix2D createPointMatrixInteger(List<Point3i> points) {
        DoubleMatrix2D matrix = DoubleFactory2D.dense.make(points.size(), 3);
        for (int i = 0; i < points.size(); ++i) {
            Point3i point = points.get(i);
            matrix.set(i, 0, (double)point.x());
            matrix.set(i, 1, (double)point.y());
            matrix.set(i, 2, (double)point.z());
        }
        return matrix;
    }

    public CalculateSecondMoments(boolean suppressZ) {
        this.suppressZ = suppressZ;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculateSecondMoments)) {
            return false;
        }
        CalculateSecondMoments other = (CalculateSecondMoments)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return this.suppressZ == other.suppressZ;
    }

    protected boolean canEqual(Object other) {
        return other instanceof CalculateSecondMoments;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.suppressZ ? 79 : 97);
        return result;
    }
}

