/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.object.single.moments;

import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.math.statistics.moment.EigenvalueAndVector;
import org.anchoranalysis.plugin.image.feature.bean.object.single.moments.SpecificAxisBase;
import org.anchoranalysis.spatial.axis.Axis;
import org.anchoranalysis.spatial.axis.AxisConversionException;
import org.anchoranalysis.spatial.axis.AxisConverter;

public class PrincipalAxisOrientation
extends SpecificAxisBase {
    @BeanField
    private String axis = "x";

    @Override
    protected double calculateFromSpecificMoment(EigenvalueAndVector moment) throws FeatureCalculationException {
        try {
            int axisIndex = AxisConverter.dimensionIndexFor((Axis)AxisConverter.createFromString((String)this.axis));
            return moment.getEigenvector().get(axisIndex);
        }
        catch (AxisConversionException e) {
            throw new FeatureCalculationException(e.friendlyMessageHierarchy());
        }
    }

    @Override
    protected String errorMessageIfTooFewPixels() throws FeatureCalculationException {
        return "Too few voxels to determine axis-orientation";
    }

    public String getAxis() {
        return this.axis;
    }

    public void setAxis(String axis) {
        this.axis = axis;
    }
}

