/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.object.single.morphological;

import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.cache.part.ResolvedPart;
import org.anchoranalysis.feature.calculate.cache.part.ResolvedPartMap;
import org.anchoranalysis.feature.calculate.part.CalculationPart;
import org.anchoranalysis.feature.calculate.part.CalculationPartMap;
import org.anchoranalysis.feature.calculate.part.CalculationPartResolver;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.image.voxel.object.morphological.MorphologicalErosion;
import org.anchoranalysis.plugin.image.feature.object.calculation.single.morphological.CalculateDilationMap;

class CalculateClosing
extends CalculationPart<ObjectMask, FeatureInputSingleObject> {
    private final int iterations;
    private final ResolvedPartMap<ObjectMask, FeatureInputSingleObject, Integer> mapDilation;
    private final boolean do3D;

    public static ResolvedPart<ObjectMask, FeatureInputSingleObject> of(CalculationPartResolver<FeatureInputSingleObject> cache, int iterations, boolean do3D) {
        ResolvedPartMap map = cache.search((CalculationPartMap)new CalculateDilationMap(do3D));
        return cache.search((CalculationPart)new CalculateClosing(iterations, (ResolvedPartMap<ObjectMask, FeatureInputSingleObject, Integer>)map, do3D));
    }

    protected ObjectMask execute(FeatureInputSingleObject input) throws FeatureCalculationException {
        try {
            ObjectMask dilated = (ObjectMask)this.mapDilation.getOrCalculate((FeatureInput)input, (Object)this.iterations);
            return MorphologicalErosion.erode((ObjectMask)dilated, (int)this.iterations, (boolean)this.do3D);
        }
        catch (CreateException e) {
            throw new FeatureCalculationException((Throwable)e);
        }
    }

    private CalculateClosing(int iterations, ResolvedPartMap<ObjectMask, FeatureInputSingleObject, Integer> mapDilation, boolean do3D) {
        this.iterations = iterations;
        this.mapDilation = mapDilation;
        this.do3D = do3D;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculateClosing)) {
            return false;
        }
        CalculateClosing other = (CalculateClosing)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.iterations != other.iterations) {
            return false;
        }
        if (this.do3D != other.do3D) {
            return false;
        }
        ResolvedPartMap<ObjectMask, FeatureInputSingleObject, Integer> this$mapDilation = this.mapDilation;
        ResolvedPartMap<ObjectMask, FeatureInputSingleObject, Integer> other$mapDilation = other.mapDilation;
        return !(this$mapDilation == null ? other$mapDilation != null : !this$mapDilation.equals(other$mapDilation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CalculateClosing;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.iterations;
        result = result * 59 + (this.do3D ? 79 : 97);
        ResolvedPartMap<ObjectMask, FeatureInputSingleObject, Integer> $mapDilation = this.mapDilation;
        result = result * 59 + ($mapDilation == null ? 43 : $mapDilation.hashCode());
        return result;
    }
}

