/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.object.single.shape;

import cern.colt.list.DoubleArrayList;
import cern.jet.stat.Descriptive;
import java.util.List;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.FeatureCalculationInput;
import org.anchoranalysis.image.core.points.PointsFromObject;
import org.anchoranalysis.image.feature.bean.object.single.FeatureSingleObject;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.point.Point3d;
import org.anchoranalysis.spatial.point.Point3i;

public class ObjectRadiusStandardDeviation
extends FeatureSingleObject {
    @BeanField
    private boolean cov = false;

    public double calculate(FeatureCalculationInput<FeatureInputSingleObject> input) throws FeatureCalculationException {
        ObjectMask object = ((FeatureInputSingleObject)input.get()).getObject();
        List pointsOutline = PointsFromObject.listFromOutline3i((ObjectMask)object);
        DoubleArrayList distances = ObjectRadiusStandardDeviation.distancesToPoints(object.centerOfGravity(), pointsOutline);
        return this.calculateStatistic(distances);
    }

    private static DoubleArrayList distancesToPoints(Point3d pointFrom, List<Point3i> pointsTo) {
        DoubleArrayList distances = new DoubleArrayList(pointsTo.size());
        for (Point3i point : pointsTo) {
            Point3d shifted = new Point3d((double)point.x() + 0.5, (double)point.y() + 0.5, (double)point.z() + 0.5);
            distances.add(pointFrom.distance(shifted));
        }
        return distances;
    }

    private double calculateStatistic(DoubleArrayList distances) {
        int size = distances.size();
        double sum = Descriptive.sum((DoubleArrayList)distances);
        double sumOfSquares = Descriptive.sumOfSquares((DoubleArrayList)distances);
        double variance = Descriptive.variance((int)size, (double)sum, (double)sumOfSquares);
        double stdDev = Descriptive.standardDeviation((double)variance);
        if (this.cov) {
            double mean = sum / (double)size;
            return stdDev / mean;
        }
        return stdDev;
    }

    public boolean isCov() {
        return this.cov;
    }

    public void setCov(boolean cov) {
        this.cov = cov;
    }
}

