/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.object.single.slice;

import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.FeatureCalculationInput;
import org.anchoranalysis.image.feature.bean.object.single.FeatureSingleObject;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.object.ObjectMask;

public class MaximumNumberVoxelsOnSlice
extends FeatureSingleObject {
    public double calculate(FeatureCalculationInput<FeatureInputSingleObject> input) throws FeatureCalculationException {
        ObjectMask single = ((FeatureInputSingleObject)input.get()).getObject();
        byte onByte = single.binaryValuesByte().getOn();
        int max = 0;
        for (int z = 0; z < single.boundingBox().extent().z(); ++z) {
            UnsignedByteBuffer buffer = single.sliceBufferLocal(z);
            int count = MaximumNumberVoxelsOnSlice.countForByteBuffer(buffer, onByte);
            if (count <= max) continue;
            max = count;
        }
        return max;
    }

    private static int countForByteBuffer(UnsignedByteBuffer buffer, byte equalValue) {
        int count = 0;
        while (buffer.hasRemaining()) {
            if (buffer.getRaw() != equalValue) continue;
            ++count;
        }
        return count;
    }
}

