/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.physical;

import java.util.Optional;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.input.FeatureInputWithResolution;
import org.anchoranalysis.image.bean.nonbean.UnitValueException;
import org.anchoranalysis.image.bean.unitvalue.extent.UnitValueExtent;
import org.anchoranalysis.image.bean.unitvalue.extent.volume.VolumeVoxels;
import org.anchoranalysis.image.core.dimensions.Resolution;
import org.anchoranalysis.image.core.dimensions.UnitConverter;
import org.anchoranalysis.image.feature.bean.physical.WithResolutionBase;

public class UnitsWithinRange<T extends FeatureInputWithResolution>
extends WithResolutionBase<T> {
    @BeanField
    private double within = 0.0;
    @BeanField
    private double outside = -10.0;
    @BeanField
    private UnitValueExtent min = new VolumeVoxels(0.0);
    @BeanField
    private UnitValueExtent max = new VolumeVoxels(Double.MAX_VALUE);

    protected double calculateWithResolution(double value, Resolution resolution) throws FeatureCalculationException {
        try {
            Optional<UnitConverter> unitConverter = Optional.of(resolution.unitConvert());
            double minVoxels = this.min.resolveToVoxels(unitConverter);
            double maxVoxels = this.max.resolveToVoxels(unitConverter);
            if (value >= minVoxels && value <= maxVoxels) {
                return this.within;
            }
            return this.outside;
        }
        catch (UnitValueException e) {
            throw new FeatureCalculationException((Throwable)e);
        }
    }

    public String describeParameters() {
        return String.format("min=%s,max=%s,within=%8.3f outside=%8.3f", this.min, this.max, this.within, this.outside);
    }

    public double getWithin() {
        return this.within;
    }

    public void setWithin(double within) {
        this.within = within;
    }

    public double getOutside() {
        return this.outside;
    }

    public void setOutside(double outside) {
        this.outside = outside;
    }

    public UnitValueExtent getMin() {
        return this.min;
    }

    public void setMin(UnitValueExtent min) {
        this.min = min;
    }

    public UnitValueExtent getMax() {
        return this.max;
    }

    public void setMax(UnitValueExtent max) {
        this.max = max;
    }
}

