/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.score;

import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.math.histogram.Histogram;
import org.anchoranalysis.plugin.image.feature.bean.score.CalculateLevelBase;
import org.anchoranalysis.plugin.image.feature.bean.score.DifferenceHelper;

public class DifferenceCalculateLevelStandardDeviation
extends CalculateLevelBase {
    @BeanField
    private int minDifference = 0;
    @BeanField
    private double widthFactor = 1.0;
    private double widthLessThan;
    private double widthGreaterThan;

    @Override
    protected void beforeCalcSetup(Histogram histogram, int level) throws OperationFailedException {
        Histogram lessThan = histogram.threshold(bin -> bin < (double)level);
        Histogram greaterThan = histogram.threshold(bin -> bin > (double)level);
        this.widthLessThan = lessThan.standardDeviation() * this.widthFactor;
        this.widthGreaterThan = greaterThan.standardDeviation() * this.widthFactor;
    }

    @Override
    protected double calculateForVoxel(int voxelIntensity, int level) {
        return DifferenceHelper.differenceFromValue(voxelIntensity, level, this.widthGreaterThan, this.widthLessThan, this.minDifference);
    }

    public int getMinDifference() {
        return this.minDifference;
    }

    public void setMinDifference(int minDifference) {
        this.minDifference = minDifference;
    }

    public double getWidthFactor() {
        return this.widthFactor;
    }

    public void setWidthFactor(double widthFactor) {
        this.widthFactor = widthFactor;
    }
}

