/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.score;

import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.image.feature.bean.VoxelScore;

public class Identity
extends VoxelScore {
    @BeanField
    private int energyChannelIndex = 0;
    @BeanField
    private boolean normalize = true;
    @BeanField
    private double factorLow = 1.0;
    @BeanField
    private double factorHigh = 1.0;
    @BeanField
    private boolean keepExtremes = false;

    public double calculate(int[] voxelIntensities) throws FeatureCalculationException {
        double pixelValue = voxelIntensities[this.energyChannelIndex];
        if (this.normalize) {
            double val = pixelValue / 255.0;
            if (this.keepExtremes) {
                if (val == 0.0) {
                    return val;
                }
                if (val == 1.0) {
                    return val;
                }
            }
            if (val < 0.5) {
                return 0.5 - (0.5 - val) * this.factorLow;
            }
            if (val > 0.5) {
                return 0.5 + (val - 0.5) * this.factorHigh;
            }
            return val;
        }
        return pixelValue;
    }

    public int getEnergyChannelIndex() {
        return this.energyChannelIndex;
    }

    public void setEnergyChannelIndex(int energyChannelIndex) {
        this.energyChannelIndex = energyChannelIndex;
    }

    public boolean isNormalize() {
        return this.normalize;
    }

    public void setNormalize(boolean normalize) {
        this.normalize = normalize;
    }

    public double getFactorLow() {
        return this.factorLow;
    }

    public void setFactorLow(double factorLow) {
        this.factorLow = factorLow;
    }

    public double getFactorHigh() {
        return this.factorHigh;
    }

    public void setFactorHigh(double factorHigh) {
        this.factorHigh = factorHigh;
    }

    public boolean isKeepExtremes() {
        return this.keepExtremes;
    }

    public void setKeepExtremes(boolean keepExtremes) {
        this.keepExtremes = keepExtremes;
    }
}

