/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.score;

import java.util.List;
import java.util.Optional;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.value.Dictionary;
import org.anchoranalysis.math.histogram.Histogram;
import org.anchoranalysis.plugin.image.feature.bean.score.SingleChannel;

public class NormalizeByMax
extends SingleChannel {
    private double maxEdge;

    public void initialize(List<Histogram> histograms, Optional<Dictionary> dictionary) throws InitializeException {
        try {
            this.maxEdge = histograms.get(this.getEnergyChannelIndex()).calculateMaximum();
        }
        catch (OperationFailedException e) {
            throw new InitializeException((Throwable)e);
        }
    }

    @Override
    protected double deriveScoreFromVoxel(int voxelIntensity) {
        return (double)voxelIntensity / this.maxEdge;
    }
}

