/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.shared.object;

import cern.colt.list.DoubleArrayList;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.SkipInit;
import org.anchoranalysis.bean.initializable.parameters.BeanInitialization;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.cache.CalculateForChild;
import org.anchoranalysis.feature.calculate.cache.ChildCacheName;
import org.anchoranalysis.feature.input.FeatureInputEnergy;
import org.anchoranalysis.image.bean.nonbean.init.ImageInitialization;
import org.anchoranalysis.image.bean.provider.ObjectCollectionProvider;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.plugin.image.feature.bean.shared.object.CalculateInputFromStack;
import org.anchoranalysis.plugin.image.feature.bean.shared.object.FeatureSingleObjectFromShared;

public abstract class ObjectAggregationBase<T extends FeatureInputEnergy>
extends FeatureSingleObjectFromShared<T> {
    @BeanField
    @SkipInit
    private ObjectCollectionProvider objects;
    private ObjectCollection createdObjects;

    @Override
    protected void beforeCalcWithInitialization(ImageInitialization initialization) throws InitializeException {
        this.objects.initializeRecursive((BeanInitialization)initialization, this.getLogger());
    }

    @Override
    protected double calc(CalculateForChild<T> calculateForChild, Feature<FeatureInputSingleObject> featureForSingleObject) throws FeatureCalculationException {
        if (this.createdObjects == null) {
            this.createdObjects = this.createObjects();
        }
        return this.deriveStatistic(this.featureValsForObjects(featureForSingleObject, calculateForChild, this.createdObjects));
    }

    protected abstract double deriveStatistic(DoubleArrayList var1);

    private ObjectCollection createObjects() throws FeatureCalculationException {
        try {
            return (ObjectCollection)this.objects.get();
        }
        catch (ProvisionFailedException e) {
            throw new FeatureCalculationException((Throwable)e);
        }
    }

    private DoubleArrayList featureValsForObjects(Feature<FeatureInputSingleObject> feature, CalculateForChild<T> calculateForChild, ObjectCollection objects) throws FeatureCalculationException {
        DoubleArrayList featureVals = new DoubleArrayList();
        for (int i = 0; i < objects.size(); ++i) {
            double value = calculateForChild.calculate(feature, new CalculateInputFromStack(objects, i), this.cacheName(i));
            featureVals.add(value);
        }
        return featureVals;
    }

    private ChildCacheName cacheName(int index) {
        return new ChildCacheName(ObjectAggregationBase.class, index + "_" + this.createdObjects.hashCode());
    }

    public ObjectCollectionProvider getObjects() {
        return this.objects;
    }

    public void setObjects(ObjectCollectionProvider objects) {
        this.objects = objects;
    }
}

