/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.stack.intensity;

import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.FeatureCalculationInput;
import org.anchoranalysis.feature.calculate.cache.ChildCacheName;
import org.anchoranalysis.feature.calculate.part.CalculationPart;
import org.anchoranalysis.feature.calculate.part.CalculationPartResolver;
import org.anchoranalysis.image.feature.bean.FeatureStack;
import org.anchoranalysis.image.feature.bean.histogram.Mean;
import org.anchoranalysis.image.feature.input.FeatureInputHistogram;
import org.anchoranalysis.image.feature.input.FeatureInputStack;
import org.anchoranalysis.math.histogram.Histogram;
import org.anchoranalysis.plugin.image.feature.bean.stack.intensity.CalculateDeriveHistogramInput;
import org.anchoranalysis.plugin.image.feature.stack.calculation.CalculateHistogram;
import org.anchoranalysis.plugin.image.feature.stack.calculation.CalculateHistogramMasked;

public class Intensity
extends FeatureStack {
    @BeanField
    private Feature<FeatureInputHistogram> item = new Mean();
    @BeanField
    private int energyIndex = 0;
    @BeanField
    private int energyIndexMask = -1;

    protected double calculate(FeatureCalculationInput<FeatureInputStack> input) throws FeatureCalculationException {
        return input.forChild().calculate(this.item, (CalculationPart)new CalculateDeriveHistogramInput(this.histogramCalculator(), (CalculationPartResolver<FeatureInputStack>)input.resolver()), new ChildCacheName(Intensity.class, this.energyIndex + "_" + this.energyIndexMask));
    }

    public String descriptionLong() {
        if (this.energyIndexMask != -1) {
            return String.format("channelMasked%d.%d/%s", this.energyIndex, this.energyIndexMask, this.item);
        }
        return String.format("channel%d/%s", this.energyIndex, this.item);
    }

    private CalculationPart<Histogram, FeatureInputStack> histogramCalculator() {
        if (this.energyIndexMask != -1) {
            return new CalculateHistogramMasked(this.energyIndex, this.energyIndexMask);
        }
        return new CalculateHistogram(this.energyIndex);
    }

    public Feature<FeatureInputHistogram> getItem() {
        return this.item;
    }

    public void setItem(Feature<FeatureInputHistogram> item) {
        this.item = item;
    }

    public int getEnergyIndex() {
        return this.energyIndex;
    }

    public void setEnergyIndex(int energyIndex) {
        this.energyIndex = energyIndex;
    }

    public int getEnergyIndexMask() {
        return this.energyIndexMask;
    }

    public void setEnergyIndexMask(int energyIndexMask) {
        this.energyIndexMask = energyIndexMask;
    }
}

