/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.stack.calculation;

import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.part.CalculationPart;
import org.anchoranalysis.image.feature.input.FeatureInputStack;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.statistics.HistogramFactory;
import org.anchoranalysis.math.histogram.Histogram;

public class CalculateHistogram
extends CalculationPart<Histogram, FeatureInputStack> {
    private final int energyIndex;

    protected Histogram execute(FeatureInputStack input) throws FeatureCalculationException {
        try {
            return HistogramFactory.createFrom((VoxelsUntyped)input.getEnergyStackRequired().getChannel(this.energyIndex).voxels());
        }
        catch (Exception e) {
            throw new FeatureCalculationException((Throwable)e);
        }
    }

    public CalculateHistogram(int energyIndex) {
        this.energyIndex = energyIndex;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculateHistogram)) {
            return false;
        }
        CalculateHistogram other = (CalculateHistogram)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return this.energyIndex == other.energyIndex;
    }

    protected boolean canEqual(Object other) {
        return other instanceof CalculateHistogram;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.energyIndex;
        return result;
    }
}

