/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.stack.calculation;

import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.part.CalculationPart;
import org.anchoranalysis.feature.energy.EnergyStackWithoutParameters;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.mask.Mask;
import org.anchoranalysis.image.core.object.HistogramFromObjectsFactory;
import org.anchoranalysis.image.feature.input.FeatureInputStack;
import org.anchoranalysis.math.histogram.Histogram;

public class CalculateHistogramMasked
extends CalculationPart<Histogram, FeatureInputStack> {
    private final int energyIndexSignal;
    private final int energyIndexMask;

    protected Histogram execute(FeatureInputStack input) throws FeatureCalculationException {
        try {
            EnergyStackWithoutParameters energyStack = input.getEnergyStackRequired().withoutParameters();
            return HistogramFromObjectsFactory.createFrom((Channel)this.extractChannel(energyStack), (Mask)this.extractMask(energyStack));
        }
        catch (CreateException e) {
            throw new FeatureCalculationException((Throwable)e);
        }
    }

    private Channel extractChannel(EnergyStackWithoutParameters energyStack) {
        return energyStack.getChannel(this.energyIndexSignal);
    }

    private Mask extractMask(EnergyStackWithoutParameters energyStack) {
        return new Mask(energyStack.getChannel(this.energyIndexMask));
    }

    public CalculateHistogramMasked(int energyIndexSignal, int energyIndexMask) {
        this.energyIndexSignal = energyIndexSignal;
        this.energyIndexMask = energyIndexMask;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculateHistogramMasked)) {
            return false;
        }
        CalculateHistogramMasked other = (CalculateHistogramMasked)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.energyIndexSignal != other.energyIndexSignal) {
            return false;
        }
        return this.energyIndexMask == other.energyIndexMask;
    }

    protected boolean canEqual(Object other) {
        return other instanceof CalculateHistogramMasked;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.energyIndexSignal;
        result = result * 59 + this.energyIndexMask;
        return result;
    }
}

