/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.histogram.threshold;

import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.shared.relation.threshold.RelationToThreshold;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.image.feature.bean.histogram.FeatureHistogramStatistic;
import org.anchoranalysis.math.histogram.Histogram;

public class RatioThreshold
extends FeatureHistogramStatistic {
    @BeanField
    private RelationToThreshold threshold;

    protected double calculateStatisticFrom(Histogram histogram) throws FeatureCalculationException {
        if (histogram.size() == 0) {
            return 0.0;
        }
        assert (histogram.size() > 0);
        long count = histogram.countMatching(this.threshold.asPredicateInt());
        return (double)count / (double)histogram.size();
    }

    public String describeParameters() {
        return String.format("%s,threshold=%s", super.describeParameters(), this.threshold.toString());
    }

    @Generated
    public RelationToThreshold getThreshold() {
        return this.threshold;
    }

    @Generated
    public void setThreshold(RelationToThreshold threshold) {
        this.threshold = threshold;
    }
}

