/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.list;

import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.bean.list.FeatureListProvider;
import org.anchoranalysis.image.feature.bean.FeatureStack;
import org.anchoranalysis.image.feature.bean.histogram.FeatureHistogramStatistic;
import org.anchoranalysis.image.feature.bean.histogram.Mean;
import org.anchoranalysis.image.feature.input.FeatureInputHistogram;
import org.anchoranalysis.image.feature.input.FeatureInputStack;
import org.anchoranalysis.plugin.image.feature.bean.histogram.statistic.Kurtosis;
import org.anchoranalysis.plugin.image.feature.bean.histogram.statistic.Skewness;
import org.anchoranalysis.plugin.image.feature.bean.histogram.statistic.StandardDeviation;
import org.anchoranalysis.plugin.image.feature.bean.histogram.statistic.Sum;
import org.anchoranalysis.plugin.image.feature.bean.histogram.statistic.Variance;
import org.anchoranalysis.plugin.image.feature.bean.stack.intensity.Intensity;
import org.apache.commons.lang.StringUtils;

public class IntensityMoments
extends FeatureListProvider<FeatureInputStack> {
    private static final int NUMBER_FEATURES = 6;
    @BeanField
    private int maximumNumberChannels = 3;

    public FeatureList<FeatureInputStack> get() throws ProvisionFailedException {
        FeatureList out = new FeatureList(6 * this.maximumNumberChannels);
        for (int channelIndex = 0; channelIndex < this.maximumNumberChannels; ++channelIndex) {
            out.addAll(this.featuresForChannel(channelIndex));
        }
        return out;
    }

    private FeatureList<FeatureInputStack> featuresForChannel(int channelIndex) {
        FeatureList out = new FeatureList(6);
        out.add((Feature)this.createFeature(channelIndex, new Sum()));
        out.add((Feature)this.createFeature(channelIndex, (FeatureHistogramStatistic)new Mean()));
        out.add((Feature)this.createFeature(channelIndex, new StandardDeviation()));
        out.add((Feature)this.createFeature(channelIndex, new Variance()));
        out.add((Feature)this.createFeature(channelIndex, new Skewness()));
        out.add((Feature)this.createFeature(channelIndex, new Kurtosis()));
        return out;
    }

    private FeatureStack createFeature(int channelIndex, FeatureHistogramStatistic statistic) {
        String statisticUncapitalized = StringUtils.uncapitalize((String)statistic.getClass().getSimpleName());
        Intensity intensity = new Intensity();
        intensity.setEnergyIndex(channelIndex);
        intensity.setItem((Feature<FeatureInputHistogram>)statistic);
        intensity.setCustomName(String.format("channel%d.%s", channelIndex, statisticUncapitalized));
        return intensity;
    }

    @Generated
    public int getMaximumNumberChannels() {
        return this.maximumNumberChannels;
    }

    @Generated
    public void setMaximumNumberChannels(int maximumNumberChannels) {
        this.maximumNumberChannels = maximumNumberChannels;
    }
}

