/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.object.combine;

import java.util.List;
import org.anchoranalysis.bean.NamedBean;
import org.anchoranalysis.bean.exception.BeanDuplicateException;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.bean.list.FeatureListFactory;
import org.anchoranalysis.feature.bean.list.FeatureListProvider;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.store.NamedFeatureStore;
import org.anchoranalysis.feature.store.NamedFeatureStoreFactory;

class FeatureListCustomNameHelper {
    private final NamedFeatureStoreFactory storeFactory;

    public FeatureListCustomNameHelper(NamedFeatureStoreFactory storeFactory) {
        this.storeFactory = storeFactory;
    }

    public <T extends FeatureInput> FeatureList<T> copyFeaturesCreateCustomName(List<NamedBean<FeatureListProvider<T>>> features) throws OperationFailedException {
        try {
            NamedFeatureStore featuresNamed = this.storeFactory.createNamedFeatureList(features);
            return FeatureListCustomNameHelper.copyFeaturesCreateCustomName(featuresNamed);
        }
        catch (ProvisionFailedException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private static <T extends FeatureInput> FeatureList<T> copyFeaturesCreateCustomName(NamedFeatureStore<T> features) throws OperationFailedException {
        try {
            return FeatureListFactory.mapFrom(features, item -> ((Feature)item.getValue()).duplicateChangeName(item.getName()));
        }
        catch (BeanDuplicateException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }
}

