/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.object.combine;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.anchoranalysis.bean.NamedBean;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.exception.BeanDuplicateException;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.core.graph.GraphWithPayload;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.feature.bean.list.FeatureListProvider;
import org.anchoranalysis.feature.energy.EnergyStack;
import org.anchoranalysis.feature.store.NamedFeatureStoreFactory;
import org.anchoranalysis.image.core.merge.ObjectMaskMerger;
import org.anchoranalysis.image.feature.calculator.FeatureTableCalculator;
import org.anchoranalysis.image.feature.calculator.merged.MergedPairsFeatures;
import org.anchoranalysis.image.feature.calculator.merged.MergedPairsInclude;
import org.anchoranalysis.image.feature.calculator.merged.PairsTableCalculator;
import org.anchoranalysis.image.feature.input.FeatureInputPairObjects;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.image.feature.input.FeatureInputStack;
import org.anchoranalysis.image.voxel.neighborhood.NeighborGraph;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectCollectionFactory;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.feature.bean.object.combine.CombineObjectsForFeatures;
import org.anchoranalysis.plugin.image.feature.bean.object.combine.FeatureListCustomNameHelper;
import org.anchoranalysis.plugin.image.feature.bean.object.combine.UniqueIdentifierUtilities;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;

public class PairNeighbors
extends CombineObjectsForFeatures<FeatureInputPairObjects> {
    @BeanField
    private List<NamedBean<FeatureListProvider<FeatureInputPairObjects>>> featuresPair = Arrays.asList(new NamedBean[0]);
    @BeanField
    private List<NamedBean<FeatureListProvider<FeatureInputStack>>> featuresImage = Arrays.asList(new NamedBean[0]);
    @BeanField
    private boolean includeFirst = true;
    @BeanField
    private boolean includeSecond = true;
    @BeanField
    private boolean includeMerged = true;
    @BeanField
    private boolean avoidOverlappingObjects = false;
    @BeanField
    private boolean do3D = true;

    @Override
    public FeatureTableCalculator<FeatureInputPairObjects> createFeatures(List<NamedBean<FeatureListProvider<FeatureInputSingleObject>>> list, NamedFeatureStoreFactory storeFactory, boolean suppressErrors) throws CreateException {
        try {
            FeatureListCustomNameHelper helper = new FeatureListCustomNameHelper(storeFactory);
            MergedPairsFeatures features = new MergedPairsFeatures(helper.copyFeaturesCreateCustomName(this.featuresImage), helper.copyFeaturesCreateCustomName(list), helper.copyFeaturesCreateCustomName(this.featuresPair));
            return new PairsTableCalculator(features, new MergedPairsInclude(this.includeFirst, this.includeSecond, this.includeMerged), suppressErrors);
        }
        catch (BeanDuplicateException | OperationFailedException e) {
            throw new CreateException(e);
        }
    }

    @Override
    public List<FeatureInputPairObjects> startBatchDeriveInputs(ObjectCollection objects, EnergyStack energyStack, Logger logger) throws CreateException {
        GraphWithPayload graphNeighbors = NeighborGraph.create((ObjectCollection)objects, (Extent)energyStack.withoutParameters().extent(), (boolean)this.avoidOverlappingObjects, (boolean)this.do3D);
        return FunctionalList.mapToList((Collection)graphNeighbors.edgesUnique(), edge -> new FeatureInputPairObjects((ObjectMask)edge.getFrom(), (ObjectMask)edge.getTo(), Optional.of(energyStack)));
    }

    @Override
    public String uniqueIdentifierFor(FeatureInputPairObjects input) {
        return UniqueIdentifierUtilities.forObjectPair(input.getFirst(), input.getSecond());
    }

    @Override
    public ObjectCollection objectsForThumbnail(FeatureInputPairObjects input) throws CreateException {
        return ObjectCollectionFactory.of((ObjectMask[])new ObjectMask[]{input.getFirst(), input.getSecond()});
    }

    @Override
    protected BoundingBox boundingBoxThatSpansInput(FeatureInputPairObjects input) {
        return ObjectMaskMerger.mergeBoundingBoxes(Stream.of(input.getFirst(), input.getSecond()));
    }

    @Generated
    public List<NamedBean<FeatureListProvider<FeatureInputPairObjects>>> getFeaturesPair() {
        return this.featuresPair;
    }

    @Generated
    public void setFeaturesPair(List<NamedBean<FeatureListProvider<FeatureInputPairObjects>>> featuresPair) {
        this.featuresPair = featuresPair;
    }

    @Generated
    public List<NamedBean<FeatureListProvider<FeatureInputStack>>> getFeaturesImage() {
        return this.featuresImage;
    }

    @Generated
    public void setFeaturesImage(List<NamedBean<FeatureListProvider<FeatureInputStack>>> featuresImage) {
        this.featuresImage = featuresImage;
    }

    @Generated
    public boolean isIncludeFirst() {
        return this.includeFirst;
    }

    @Generated
    public void setIncludeFirst(boolean includeFirst) {
        this.includeFirst = includeFirst;
    }

    @Generated
    public boolean isIncludeSecond() {
        return this.includeSecond;
    }

    @Generated
    public void setIncludeSecond(boolean includeSecond) {
        this.includeSecond = includeSecond;
    }

    @Generated
    public boolean isIncludeMerged() {
        return this.includeMerged;
    }

    @Generated
    public void setIncludeMerged(boolean includeMerged) {
        this.includeMerged = includeMerged;
    }

    @Generated
    public boolean isAvoidOverlappingObjects() {
        return this.avoidOverlappingObjects;
    }

    @Generated
    public void setAvoidOverlappingObjects(boolean avoidOverlappingObjects) {
        this.avoidOverlappingObjects = avoidOverlappingObjects;
    }

    @Generated
    public boolean isDo3D() {
        return this.do3D;
    }

    @Generated
    public void setDo3D(boolean do3D) {
        this.do3D = do3D;
    }
}

