/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.object.single.intensity;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.BeanInstanceMap;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.exception.BeanMisconfiguredException;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.FeatureCalculationInput;
import org.anchoranalysis.feature.calculate.part.CalculationPartResolver;
import org.anchoranalysis.feature.energy.EnergyStackWithoutParameters;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesInt;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.feature.bean.morphological.MorphologicalIterations;
import org.anchoranalysis.plugin.image.feature.bean.object.single.intensity.FeatureEnergyChannel;
import org.anchoranalysis.plugin.image.feature.object.calculation.single.CalculateShellObjectMask;
import org.anchoranalysis.spatial.box.BoundingBox;

public abstract class IntensityMeanShellBase
extends FeatureEnergyChannel {
    @BeanField
    private MorphologicalIterations iterations = new MorphologicalIterations();
    @BeanField
    private boolean inverse = false;
    @BeanField
    private int energyIndexMask = -1;
    @BeanField
    private boolean inverseMask = false;
    @BeanField
    private double emptyValue = 255.0;

    public void checkMisconfigured(BeanInstanceMap defaultInstances) throws BeanMisconfiguredException {
        super.checkMisconfigured(defaultInstances);
        if (!this.iterations.isAtLeastOnePositive()) {
            throw new BeanMisconfiguredException("At least one of iterationsDilation and iterationsErosion must be positive");
        }
    }

    public String describeParameters() {
        return String.format("%s,%s,inverse=%s", super.describeParameters(), this.iterations.describePropertiesFriendly(), this.inverse ? "true" : "false");
    }

    @Override
    protected double calculateForChannel(FeatureCalculationInput<FeatureInputSingleObject> input, Channel channel) throws FeatureCalculationException {
        ObjectMask objectShell = this.createShell(input);
        if (this.energyIndexMask != -1) {
            Optional<ObjectMask> omIntersected = this.intersectWithEnergyMask(objectShell, ((FeatureInputSingleObject)input.get()).getEnergyStackRequired().withoutParameters());
            if (omIntersected.isPresent()) {
                objectShell = omIntersected.get();
            } else {
                return this.emptyValue;
            }
        }
        return this.calculateForShell(objectShell, channel);
    }

    protected abstract double calculateForShell(ObjectMask var1, Channel var2) throws FeatureCalculationException;

    private ObjectMask createShell(FeatureCalculationInput<FeatureInputSingleObject> input) throws FeatureCalculationException {
        return (ObjectMask)input.calculate(CalculateShellObjectMask.of((CalculationPartResolver<FeatureInputSingleObject>)input.resolver(), this.iterations, 0, this.inverse));
    }

    private Optional<ObjectMask> intersectWithEnergyMask(ObjectMask object, EnergyStackWithoutParameters energyStack) {
        return object.intersect(this.createEnergyMask(energyStack), energyStack.extent());
    }

    private ObjectMask createEnergyMask(EnergyStackWithoutParameters energyStack) {
        return new ObjectMask(new BoundingBox(energyStack.extent()), energyStack.getChannel(this.energyIndexMask).voxels().asByte(), this.inverseMask ? BinaryValuesInt.getDefault().createInverted() : BinaryValuesInt.getDefault());
    }

    @Generated
    public MorphologicalIterations getIterations() {
        return this.iterations;
    }

    @Generated
    public void setIterations(MorphologicalIterations iterations) {
        this.iterations = iterations;
    }

    @Generated
    public boolean isInverse() {
        return this.inverse;
    }

    @Generated
    public void setInverse(boolean inverse) {
        this.inverse = inverse;
    }

    @Generated
    public int getEnergyIndexMask() {
        return this.energyIndexMask;
    }

    @Generated
    public void setEnergyIndexMask(int energyIndexMask) {
        this.energyIndexMask = energyIndexMask;
    }

    @Generated
    public boolean isInverseMask() {
        return this.inverseMask;
    }

    @Generated
    public void setInverseMask(boolean inverseMask) {
        this.inverseMask = inverseMask;
    }

    @Generated
    public double getEmptyValue() {
        return this.emptyValue;
    }

    @Generated
    public void setEmptyValue(double emptyValue) {
        this.emptyValue = emptyValue;
    }
}

