/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.object.single.intensity.gradient;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.part.CalculationPart;
import org.anchoranalysis.feature.energy.EnergyStackWithoutParameters;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesByte;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.Point3d;

class CalculateGradientFromChannels
extends CalculationPart<List<Point3d>, FeatureInputSingleObject> {
    private int energyIndexX;
    private int energyIndexY;
    private int energyIndexZ;
    private int subtractConstant = 0;

    protected List<Point3d> execute(FeatureInputSingleObject input) throws FeatureCalculationException {
        if (this.energyIndexX == -1 || this.energyIndexY == -1) {
            throw new FeatureCalculationException((Throwable)new InitializeException("energyIndexX and energyIndexY must both be nonZero"));
        }
        ArrayList<Point3d> out = new ArrayList<Point3d>();
        EnergyStackWithoutParameters energyStack = input.getEnergyStackRequired().withoutParameters();
        this.putGradientValue(input.getObject(), out, 0, energyStack.getChannel(this.energyIndexX));
        this.putGradientValue(input.getObject(), out, 1, energyStack.getChannel(this.energyIndexY));
        if (this.energyIndexZ != -1) {
            this.putGradientValue(input.getObject(), out, 2, energyStack.getChannel(this.energyIndexZ));
        }
        return out;
    }

    private void putGradientValue(ObjectMask object, List<Point3d> points, int axisIndex, Channel channel) {
        BinaryVoxels binaryValues = object.binaryVoxels();
        Voxels voxels = channel.voxels().any();
        BoundingBox box = object.boundingBox();
        Extent extent = voxels.extent();
        Extent extentMask = box.extent();
        BinaryValuesByte binaryValuesMask = binaryValues.binaryValues().asByte();
        int pointIndex = 0;
        for (int z = 0; z < extentMask.z(); ++z) {
            VoxelBuffer buffer = voxels.slice(z + box.cornerMin().z());
            VoxelBuffer bufferMask = binaryValues.voxels().slice(z);
            for (int y = 0; y < extentMask.y(); ++y) {
                for (int x = 0; x < extentMask.x(); ++x) {
                    int offsetMask = extentMask.offset(x, y);
                    if (((UnsignedByteBuffer)bufferMask.buffer()).getRaw(offsetMask) != binaryValuesMask.getOn()) continue;
                    int offset = extent.offset(x + box.cornerMin().x(), y + box.cornerMin().y());
                    int gradVal = buffer.getInt(offset) - this.subtractConstant;
                    CalculateGradientFromChannels.modifyOrAddPoint(points, pointIndex, gradVal, axisIndex);
                    ++pointIndex;
                }
            }
        }
        assert (points.size() == pointIndex);
    }

    private static void modifyOrAddPoint(List<Point3d> points, int pointIndex, int gradVal, int axisIndex) {
        Point3d out = null;
        if (pointIndex == points.size()) {
            out = new Point3d(0.0, 0.0, 0.0);
            points.add(out);
        } else {
            out = points.get(pointIndex);
        }
        assert (out != null);
        out.setValueByDimension(axisIndex, (double)gradVal);
    }

    @Generated
    public CalculateGradientFromChannels(int energyIndexX, int energyIndexY, int energyIndexZ, int subtractConstant) {
        this.energyIndexX = energyIndexX;
        this.energyIndexY = energyIndexY;
        this.energyIndexZ = energyIndexZ;
        this.subtractConstant = subtractConstant;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculateGradientFromChannels)) {
            return false;
        }
        CalculateGradientFromChannels other = (CalculateGradientFromChannels)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.energyIndexX != other.energyIndexX) {
            return false;
        }
        if (this.energyIndexY != other.energyIndexY) {
            return false;
        }
        if (this.energyIndexZ != other.energyIndexZ) {
            return false;
        }
        return this.subtractConstant == other.subtractConstant;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalculateGradientFromChannels;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.energyIndexX;
        result = result * 59 + this.energyIndexY;
        result = result * 59 + this.energyIndexZ;
        result = result * 59 + this.subtractConstant;
        return result;
    }
}

