/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.object.single.moments;

import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.FeatureCalculationInput;
import org.anchoranalysis.feature.calculate.part.CalculationPart;
import org.anchoranalysis.image.feature.bean.object.single.FeatureSingleObject;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.math.statistics.moment.ImageMoments;
import org.anchoranalysis.plugin.image.feature.bean.object.single.moments.CalculateSecondMoments;

public abstract class ImageMomentsBase
extends FeatureSingleObject {
    private static final int MIN_NUM_VOXELS = 12;
    @BeanField
    private boolean suppressZ = false;
    @BeanField
    private double valueIfTooFewVoxels = Double.NaN;

    public double calculate(FeatureCalculationInput<FeatureInputSingleObject> input) throws FeatureCalculationException {
        if (((FeatureInputSingleObject)input.get()).getObject().voxelsOn().lowerCountExistsThan(12)) {
            String errorMessage = this.errorMessageIfTooFewPixels();
            this.getLogger().errorReporter().recordError(ImageMomentsBase.class, errorMessage);
            return this.valueIfTooFewVoxels;
        }
        return this.calculateFromAllMoments(this.calculateMoments(input));
    }

    protected abstract double calculateFromAllMoments(ImageMoments var1) throws FeatureCalculationException;

    protected abstract String errorMessageIfTooFewPixels() throws FeatureCalculationException;

    private ImageMoments calculateMoments(FeatureCalculationInput<FeatureInputSingleObject> input) throws FeatureCalculationException {
        ImageMoments moments = (ImageMoments)input.calculate((CalculationPart)new CalculateSecondMoments(this.suppressZ));
        moments = moments.duplicate();
        return moments;
    }

    @Generated
    public boolean isSuppressZ() {
        return this.suppressZ;
    }

    @Generated
    public void setSuppressZ(boolean suppressZ) {
        this.suppressZ = suppressZ;
    }

    @Generated
    public double getValueIfTooFewVoxels() {
        return this.valueIfTooFewVoxels;
    }

    @Generated
    public void setValueIfTooFewVoxels(double valueIfTooFewVoxels) {
        this.valueIfTooFewVoxels = valueIfTooFewVoxels;
    }
}

