/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.object.single.moments;

import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.math.statistics.moment.ImageMoments;
import org.anchoranalysis.plugin.image.feature.bean.object.single.moments.ImageMomentsBase;

public class PrincipalAxisEccentricity
extends ImageMomentsBase {
    public static double calculateEccentricity(double eigenvalSmaller, double eigenvalLarger) {
        return Math.sqrt(1.0 - eigenvalSmaller / eigenvalLarger);
    }

    @Override
    protected double calculateFromAllMoments(ImageMoments moments) throws FeatureCalculationException {
        moments.removeClosestToUnitZ();
        double moments0 = moments.get(0).getEigenvalue();
        double moments1 = moments.get(1).getEigenvalue();
        if (moments0 == 0.0 && moments1 == 0.0) {
            return 1.0;
        }
        if (moments0 == 0.0 || moments1 == 0.0) {
            throw new FeatureCalculationException("All moments are 0");
        }
        double eccentricity = PrincipalAxisEccentricity.calculateEccentricity(moments1, moments0);
        assert (!Double.isNaN(eccentricity));
        return eccentricity;
    }

    @Override
    protected String errorMessageIfTooFewPixels() {
        return "Too few voxels to determine principal axes and therefore eccentricity";
    }
}

