/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.score;

import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.math.histogram.Histogram;
import org.anchoranalysis.plugin.image.feature.bean.score.CalculateLevelBase;

public class CalculateLevel
extends CalculateLevelBase {
    @BeanField
    private double distanceMax = 20.0;
    private double distanceMaxDivider;

    @Override
    protected void beforeCalcSetup(Histogram histogram, int level) {
        this.distanceMaxDivider = this.distanceMax * 2.0;
    }

    @Override
    protected double calculateForVoxel(int voxelIntensity, int level) {
        if (voxelIntensity < level) {
            int diff = level - voxelIntensity;
            if ((double)diff > this.distanceMax) {
                return 0.0;
            }
            double mem = (double)diff / this.distanceMaxDivider;
            return 0.5 - mem;
        }
        int diff = voxelIntensity - level;
        if ((double)diff > this.distanceMax) {
            return 1.0;
        }
        double mem = (double)diff / this.distanceMaxDivider;
        return 0.5 + mem;
    }

    @Generated
    public double getDistanceMax() {
        return this.distanceMax;
    }

    @Generated
    public void setDistanceMax(double distanceMax) {
        this.distanceMax = distanceMax;
    }
}

