/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.score;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.shared.relation.RelationBean;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.value.Dictionary;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.image.feature.bean.VoxelScore;
import org.anchoranalysis.math.histogram.Histogram;

public class IdentityImposeValueRelationToHistogram
extends VoxelScore {
    @BeanField
    private int energyChannelIndexCheck = 0;
    @BeanField
    private int energyChannelIndexFail = 0;
    @BeanField
    private int histogramIndex = 0;
    @BeanField
    private RelationBean relation;
    @BeanField
    private double value = 0.0;
    @BeanField
    private boolean max = true;
    private int histogramMax;

    public double calculate(int[] voxelIntensities) throws FeatureCalculationException {
        double pixelValue = voxelIntensities[this.energyChannelIndexCheck];
        if (this.relation.create().test(pixelValue, (double)this.histogramMax)) {
            return this.value;
        }
        return voxelIntensities[this.energyChannelIndexFail];
    }

    public void initialize(List<Histogram> histograms, Optional<Dictionary> dictionary) throws InitializeException {
        try {
            this.histogramMax = this.max ? histograms.get(this.histogramIndex).calculateMaximum() : histograms.get(this.histogramIndex).calculateMinimum();
        }
        catch (OperationFailedException e) {
            throw new InitializeException((Throwable)e);
        }
    }

    @Generated
    public int getEnergyChannelIndexCheck() {
        return this.energyChannelIndexCheck;
    }

    @Generated
    public void setEnergyChannelIndexCheck(int energyChannelIndexCheck) {
        this.energyChannelIndexCheck = energyChannelIndexCheck;
    }

    @Generated
    public int getEnergyChannelIndexFail() {
        return this.energyChannelIndexFail;
    }

    @Generated
    public void setEnergyChannelIndexFail(int energyChannelIndexFail) {
        this.energyChannelIndexFail = energyChannelIndexFail;
    }

    @Generated
    public int getHistogramIndex() {
        return this.histogramIndex;
    }

    @Generated
    public void setHistogramIndex(int histogramIndex) {
        this.histogramIndex = histogramIndex;
    }

    @Generated
    public RelationBean getRelation() {
        return this.relation;
    }

    @Generated
    public void setRelation(RelationBean relation) {
        this.relation = relation;
    }

    @Generated
    public double getValue() {
        return this.value;
    }

    @Generated
    public void setValue(double value) {
        this.value = value;
    }

    @Generated
    public boolean isMax() {
        return this.max;
    }

    @Generated
    public void setMax(boolean max) {
        this.max = max;
    }
}

