/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.shared.object;

import lombok.Generated;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.part.CalculationPart;
import org.anchoranalysis.feature.input.FeatureInputEnergy;
import org.anchoranalysis.image.core.mask.Mask;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.binary.BinaryVoxelsFactory;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesInt;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.datatype.IncorrectVoxelTypeException;
import org.anchoranalysis.image.voxel.object.ObjectMask;

class CalculateMaskInput<T extends FeatureInputEnergy>
extends CalculationPart<FeatureInputSingleObject, T> {
    private final Mask mask;

    protected FeatureInputSingleObject execute(T input) throws FeatureCalculationException {
        BinaryVoxels<UnsignedByteBuffer> binaryValues = CalculateMaskInput.binaryVoxels(this.mask);
        return new FeatureInputSingleObject(new ObjectMask(binaryValues), input.getEnergyStackOptional());
    }

    private static BinaryVoxels<UnsignedByteBuffer> binaryVoxels(Mask mask) throws FeatureCalculationException {
        Voxels voxels;
        try {
            voxels = mask.channel().voxels().asByte();
        }
        catch (IncorrectVoxelTypeException e) {
            throw new FeatureCalculationException("mask has incompatible data type, it must be unsigned 8-bit", (Throwable)e);
        }
        return BinaryVoxelsFactory.reuseByte((Voxels)voxels, (BinaryValuesInt)mask.binaryValuesInt());
    }

    @Generated
    public CalculateMaskInput(Mask mask) {
        this.mask = mask;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculateMaskInput)) {
            return false;
        }
        CalculateMaskInput other = (CalculateMaskInput)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Mask this$mask = this.mask;
        Mask other$mask = other.mask;
        return !(this$mask == null ? other$mask != null : !this$mask.equals(other$mask));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalculateMaskInput;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Mask $mask = this.mask;
        result = result * 59 + ($mask == null ? 43 : $mask.hashCode());
        return result;
    }
}

