/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.stack.object;

import cern.colt.list.DoubleArrayList;
import cern.jet.stat.Descriptive;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.FeatureCalculationInput;
import org.anchoranalysis.feature.calculate.cache.ChildCacheName;
import org.anchoranalysis.feature.calculate.cache.part.ResolvedPart;
import org.anchoranalysis.feature.calculate.part.CalculationPart;
import org.anchoranalysis.image.feature.bean.FeatureStack;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.image.feature.input.FeatureInputStack;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.plugin.image.feature.bean.stack.object.CalculateConnectedComponents;
import org.anchoranalysis.plugin.image.feature.bean.stack.object.CalculateDeriveObjectFromCollection;

public class QuantileAcrossConnectedComponents
extends FeatureStack {
    @BeanField
    private Feature<FeatureInputSingleObject> item;
    @BeanField
    private int energyChannelIndex = 0;
    @BeanField
    private double quantile = 0.5;

    public double calculate(FeatureCalculationInput<FeatureInputStack> input) throws FeatureCalculationException {
        ResolvedPart ccObjects = input.resolver().search((CalculationPart)new CalculateConnectedComponents(this.energyChannelIndex));
        int size = ((ObjectCollection)input.calculate(ccObjects)).size();
        DoubleArrayList featureVals = new DoubleArrayList();
        for (int i = 0; i < size; ++i) {
            double val = input.forChild().calculate(this.item, (CalculationPart)new CalculateDeriveObjectFromCollection((ResolvedPart<ObjectCollection, FeatureInputStack>)ccObjects, i), this.cacheName(i));
            featureVals.add(val);
        }
        featureVals.sort();
        return Descriptive.quantile((DoubleArrayList)featureVals, (double)0.5);
    }

    private ChildCacheName cacheName(int index) {
        return new ChildCacheName(QuantileAcrossConnectedComponents.class, this.energyChannelIndex + "_" + index);
    }

    @Generated
    public Feature<FeatureInputSingleObject> getItem() {
        return this.item;
    }

    @Generated
    public void setItem(Feature<FeatureInputSingleObject> item) {
        this.item = item;
    }

    @Generated
    public int getEnergyChannelIndex() {
        return this.energyChannelIndex;
    }

    @Generated
    public void setEnergyChannelIndex(int energyChannelIndex) {
        this.energyChannelIndex = energyChannelIndex;
    }

    @Generated
    public double getQuantile() {
        return this.quantile;
    }

    @Generated
    public void setQuantile(double quantile) {
        this.quantile = quantile;
    }
}

