/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.object.calculation.single;

import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.part.CalculationPartMap;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.box.Extent;

public abstract class CalculateIncrementalOperationMap
extends CalculationPartMap<ObjectMask, FeatureInputSingleObject, Integer, FeatureCalculationException> {
    private boolean do3D;

    protected CalculateIncrementalOperationMap(boolean do3D) {
        super(100);
        this.do3D = do3D;
    }

    protected CalculateIncrementalOperationMap(CalculateIncrementalOperationMap other) {
        super(100);
        this.do3D = other.do3D;
    }

    protected ObjectMask execute(FeatureInputSingleObject input, Integer key) throws FeatureCalculationException {
        Extent extent = input.dimensionsRequired().extent();
        if (key == 0) {
            throw new FeatureCalculationException("Key must be > 0");
        }
        int lowestExistingKey = this.findHighestExistingKey(key - 1);
        ObjectMask object = lowestExistingKey != 0 ? (ObjectMask)this.getOrNull(lowestExistingKey) : input.getObject();
        try {
            for (int i = lowestExistingKey + 1; i <= key; ++i) {
                ObjectMask next = this.applyOperation(object, extent, this.do3D);
                if (i != key) {
                    this.put(i, next);
                }
                object = next;
            }
            return object;
        }
        catch (OperationFailedException e) {
            throw new FeatureCalculationException((Throwable)e);
        }
    }

    protected abstract ObjectMask applyOperation(ObjectMask var1, Extent var2, boolean var3) throws OperationFailedException;

    private int findHighestExistingKey(int max) {
        for (int i = max; i >= 1; --i) {
            if (!this.hasKey(i)) continue;
            return i;
        }
        return 0;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculateIncrementalOperationMap)) {
            return false;
        }
        CalculateIncrementalOperationMap other = (CalculateIncrementalOperationMap)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return this.do3D == other.do3D;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalculateIncrementalOperationMap;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.do3D ? 79 : 97);
        return result;
    }
}

