/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.object.calculation.single;

import lombok.Generated;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.cache.part.ResolvedPartMap;
import org.anchoranalysis.feature.calculate.part.CalculationPart;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.image.voxel.object.ObjectMask;

public abstract class CalculateObjectMask
extends CalculationPart<ObjectMask, FeatureInputSingleObject> {
    private final int iterations;
    private final ResolvedPartMap<ObjectMask, FeatureInputSingleObject, Integer> map;

    protected CalculateObjectMask(CalculateObjectMask source) {
        this.iterations = source.iterations;
        this.map = source.map;
    }

    protected ObjectMask execute(FeatureInputSingleObject input) throws FeatureCalculationException {
        if (this.iterations == 0) {
            return input.getObject();
        }
        return (ObjectMask)this.map.getOrCalculate((FeatureInput)input, (Object)this.iterations);
    }

    public String toString() {
        return String.format("%s(iterations=%d,map=%s", super.getClass().getSimpleName(), this.iterations, this.map.toString());
    }

    @Generated
    protected CalculateObjectMask(int iterations, ResolvedPartMap<ObjectMask, FeatureInputSingleObject, Integer> map) {
        this.iterations = iterations;
        this.map = map;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculateObjectMask)) {
            return false;
        }
        CalculateObjectMask other = (CalculateObjectMask)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.iterations != other.iterations) {
            return false;
        }
        ResolvedPartMap<ObjectMask, FeatureInputSingleObject, Integer> this$map = this.map;
        ResolvedPartMap<ObjectMask, FeatureInputSingleObject, Integer> other$map = other.map;
        return !(this$map == null ? other$map != null : !this$map.equals(other$map));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalculateObjectMask;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.iterations;
        ResolvedPartMap<ObjectMask, FeatureInputSingleObject, Integer> $map = this.map;
        result = result * 59 + ($map == null ? 43 : $map.hashCode());
        return result;
    }
}

