/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.object.calculation.single;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.cache.part.ResolvedPart;
import org.anchoranalysis.feature.calculate.part.CalculationPart;
import org.anchoranalysis.feature.calculate.part.CalculationPartResolver;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.image.voxel.object.morphological.MorphologicalErosion;
import org.anchoranalysis.plugin.image.feature.bean.morphological.MorphologicalIterations;
import org.anchoranalysis.plugin.image.feature.object.calculation.single.morphological.CalculateDilation;
import org.anchoranalysis.plugin.image.feature.object.calculation.single.morphological.CalculateErosion;
import org.anchoranalysis.spatial.box.Extent;

public class CalculateShellObjectMask
extends CalculationPart<ObjectMask, FeatureInputSingleObject> {
    private final ResolvedPart<ObjectMask, FeatureInputSingleObject> calculateDilation;
    private final ResolvedPart<ObjectMask, FeatureInputSingleObject> calculateErosion;
    private final int iterationsErosionSecond;
    private final boolean do3D;
    private final boolean inverse;

    public static CalculationPart<ObjectMask, FeatureInputSingleObject> of(CalculationPartResolver<FeatureInputSingleObject> resolver, MorphologicalIterations iterations, int iterationsErosionSecond, boolean inverse) {
        ResolvedPart<ObjectMask, FeatureInputSingleObject> partDilation = CalculateDilation.of(resolver, iterations.getIterationsDilation(), iterations.isDo3D());
        ResolvedPart<ObjectMask, FeatureInputSingleObject> partErosion = CalculateErosion.ofResolved(resolver, iterations.getIterationsErosion(), iterations.isDo3D());
        return new CalculateShellObjectMask(partDilation, partErosion, iterationsErosionSecond, iterations.isDo3D(), inverse);
    }

    protected ObjectMask execute(FeatureInputSingleObject input) throws FeatureCalculationException {
        Extent extent = input.dimensionsRequired().extent();
        ObjectMask shell = this.createShellObject(input);
        if (this.inverse) {
            ObjectMask duplicated = input.getObject().duplicate();
            Optional omShellIntersected = shell.intersect(duplicated, extent);
            omShellIntersected.ifPresent(shellIntersected -> CalculateShellObjectMask.assignOffTo(duplicated, shellIntersected));
            return duplicated;
        }
        return shell;
    }

    public String toString() {
        return String.format("%s ccDilation=%s, ccErosion=%s, do3D=%s, inverse=%s, iterationsErosionSecond=%d", super.toString(), this.calculateDilation.toString(), this.calculateErosion.toString(), this.do3D ? "true" : "false", this.inverse ? "true" : "false", this.iterationsErosionSecond);
    }

    private ObjectMask createShellObject(FeatureInputSingleObject input) throws FeatureCalculationException {
        ObjectMask dilated = ((ObjectMask)this.calculateDilation.getOrCalculate((FeatureInput)input)).duplicate();
        ObjectMask eroded = (ObjectMask)this.calculateErosion.getOrCalculate((FeatureInput)input);
        dilated = this.maybeErodeSecondTime(dilated);
        CalculateShellObjectMask.assignOffTo(dilated, eroded);
        return dilated;
    }

    private ObjectMask maybeErodeSecondTime(ObjectMask object) throws FeatureCalculationException {
        try {
            if (this.iterationsErosionSecond > 0) {
                return MorphologicalErosion.erode((ObjectMask)object, (int)this.iterationsErosionSecond, (boolean)this.do3D);
            }
            return object;
        }
        catch (CreateException e) {
            throw new FeatureCalculationException((Throwable)e);
        }
    }

    private static void assignOffTo(ObjectMask toAssignTo, ObjectMask objectMask) {
        toAssignTo.assignOff().toObject(objectMask);
    }

    @Generated
    public CalculateShellObjectMask(ResolvedPart<ObjectMask, FeatureInputSingleObject> calculateDilation, ResolvedPart<ObjectMask, FeatureInputSingleObject> calculateErosion, int iterationsErosionSecond, boolean do3D, boolean inverse) {
        this.calculateDilation = calculateDilation;
        this.calculateErosion = calculateErosion;
        this.iterationsErosionSecond = iterationsErosionSecond;
        this.do3D = do3D;
        this.inverse = inverse;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculateShellObjectMask)) {
            return false;
        }
        CalculateShellObjectMask other = (CalculateShellObjectMask)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.iterationsErosionSecond != other.iterationsErosionSecond) {
            return false;
        }
        if (this.do3D != other.do3D) {
            return false;
        }
        if (this.inverse != other.inverse) {
            return false;
        }
        ResolvedPart<ObjectMask, FeatureInputSingleObject> this$calculateDilation = this.calculateDilation;
        ResolvedPart<ObjectMask, FeatureInputSingleObject> other$calculateDilation = other.calculateDilation;
        if (this$calculateDilation == null ? other$calculateDilation != null : !this$calculateDilation.equals(other$calculateDilation)) {
            return false;
        }
        ResolvedPart<ObjectMask, FeatureInputSingleObject> this$calculateErosion = this.calculateErosion;
        ResolvedPart<ObjectMask, FeatureInputSingleObject> other$calculateErosion = other.calculateErosion;
        return !(this$calculateErosion == null ? other$calculateErosion != null : !this$calculateErosion.equals(other$calculateErosion));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalculateShellObjectMask;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.iterationsErosionSecond;
        result = result * 59 + (this.do3D ? 79 : 97);
        result = result * 59 + (this.inverse ? 79 : 97);
        ResolvedPart<ObjectMask, FeatureInputSingleObject> $calculateDilation = this.calculateDilation;
        result = result * 59 + ($calculateDilation == null ? 43 : $calculateDilation.hashCode());
        ResolvedPart<ObjectMask, FeatureInputSingleObject> $calculateErosion = this.calculateErosion;
        result = result * 59 + ($calculateErosion == null ? 43 : $calculateErosion.hashCode());
        return result;
    }
}

