/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.dimensions;

import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.input.FeatureInputEnergy;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.dimensions.Resolution;
import org.anchoranalysis.plugin.image.feature.bean.dimensions.ForSpecificAxis;
import org.anchoranalysis.spatial.axis.Axis;

public class VoxelPhysicalSize<T extends FeatureInputEnergy>
extends ForSpecificAxis<T> {
    @BeanField
    private boolean acceptMissingResolution = false;

    @Override
    protected double calculateForAxis(Dimensions dimensions, Axis axis) throws FeatureCalculationException {
        if (dimensions.resolution().isPresent()) {
            return ((Resolution)dimensions.resolution().get()).valueByDimension(axis);
        }
        if (this.acceptMissingResolution) {
            return Double.NaN;
        }
        throw new FeatureCalculationException("No image-resolution is present, so physical voxel size is not specified.");
    }

    @Generated
    public boolean isAcceptMissingResolution() {
        return this.acceptMissingResolution;
    }

    @Generated
    public void setAcceptMissingResolution(boolean acceptMissingResolution) {
        this.acceptMissingResolution = acceptMissingResolution;
    }
}

