/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.histogram.statistic;

import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.image.feature.bean.histogram.FeatureHistogramStatistic;
import org.anchoranalysis.math.histogram.Histogram;

public class RatioNonMode
extends FeatureHistogramStatistic {
    @BeanField
    private boolean ignoreZero = false;

    protected double calculateStatisticFrom(Histogram histogram) throws FeatureCalculationException {
        try {
            int startV = this.ignoreZero ? 1 : 0;
            int mode = this.findMode(histogram, startV);
            int totalCount = 0;
            int nonModalCount = 0;
            for (int value = startV; value < 255; ++value) {
                long count = histogram.getCount(value);
                if (count == 0L) continue;
                if (value != mode) {
                    nonModalCount = (int)((long)nonModalCount + count);
                }
                totalCount = (int)((long)totalCount + count);
            }
            if (totalCount == 0) {
                return Double.POSITIVE_INFINITY;
            }
            return (double)nonModalCount / (double)totalCount;
        }
        catch (IndexOutOfBoundsException e) {
            throw new FeatureCalculationException((Throwable)e);
        }
    }

    private int findMode(Histogram histogram, int startValue) {
        int maxIndex = -1;
        long maxValue = -1L;
        for (int value = startValue; value < 255; ++value) {
            long count = histogram.getCount(value);
            if (count <= maxValue) continue;
            maxValue = count;
            maxIndex = value;
        }
        return maxIndex;
    }

    @Generated
    public boolean isIgnoreZero() {
        return this.ignoreZero;
    }

    @Generated
    public void setIgnoreZero(boolean ignoreZero) {
        this.ignoreZero = ignoreZero;
    }
}

