/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.list.permute;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.anchoranalysis.bean.BeanInstanceMap;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.bean.exception.BeanDuplicateException;
import org.anchoranalysis.bean.exception.BeanMisconfiguredException;
import org.anchoranalysis.bean.initializable.CheckMisconfigured;
import org.anchoranalysis.bean.initializable.parameters.BeanInitialization;
import org.anchoranalysis.bean.permute.PermutedCopyCreator;
import org.anchoranalysis.bean.permute.assign.AssignPermutationException;
import org.anchoranalysis.bean.permute.assign.PermutationAssigner;
import org.anchoranalysis.bean.permute.property.PermuteProperty;
import org.anchoranalysis.bean.primitive.StringSet;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.identifier.provider.NamedProviderGetException;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.bean.list.FeatureListFactory;
import org.anchoranalysis.feature.initialization.FeatureRelatedInitialization;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.plugin.image.feature.bean.list.permute.PermuteFeatureBase;

public class PermuteFeature<S, T extends FeatureInput>
extends PermuteFeatureBase<T> {
    @BeanField
    @OptionalBean
    private StringSet referencesFeatureListCreator;
    @BeanField
    @OptionalBean
    private PermuteProperty<S> permutation;
    @BeanField
    private List<PermuteProperty<S>> permutations = Arrays.asList(new PermuteProperty[0]);

    public void checkMisconfigured(BeanInstanceMap defaultInstances) throws BeanMisconfiguredException {
        super.checkMisconfigured(defaultInstances);
        CheckMisconfigured.oneOnly((String)"permutation", (String)"permutations", (this.permutation != null ? 1 : 0) != 0, (!this.permutations.isEmpty() ? 1 : 0) != 0);
    }

    @Override
    protected FeatureList<T> createPermutedFeaturesFor(Feature<T> feature) throws ProvisionFailedException {
        List list = this.createInitialList(feature).asList();
        for (PermuteProperty<S> permute : this.permutationsAsList()) {
            try {
                PermutationAssigner assigner = permute.createSetter(feature);
                list = new PermutedCopyCreator(Feature::getCustomName, Feature::setCustomName).createPermutedCopies(list, permute, assigner);
            }
            catch (AssignPermutationException e) {
                throw new ProvisionFailedException(String.format("Cannot create a permutation-setter for %s", permute), (Throwable)e);
            }
            catch (CreateException e) {
                throw new ProvisionFailedException((Throwable)e);
            }
        }
        return FeatureListFactory.wrapReuse((List)list);
    }

    public void onInitialization(FeatureRelatedInitialization so) throws InitializeException {
        super.onInitialization((BeanInitialization)so);
        if (this.referencesFeatureListCreator != null && so != null) {
            for (String s : this.referencesFeatureListCreator.set()) {
                try {
                    ((FeatureRelatedInitialization)this.getInitialization()).getFeatureLists().getException(s);
                }
                catch (NamedProviderGetException e) {
                    throw new InitializeException(e.summarize());
                }
            }
        }
    }

    private List<PermuteProperty<S>> permutationsAsList() {
        if (!this.permutations.isEmpty()) {
            return this.permutations;
        }
        return Arrays.asList(this.permutation);
    }

    private FeatureList<T> createInitialList(Feature<T> feature) throws ProvisionFailedException {
        try {
            return FeatureListFactory.from((Feature[])new Feature[]{this.duplicateAndRemoveName(feature)});
        }
        catch (BeanDuplicateException e) {
            throw new ProvisionFailedException((Throwable)e);
        }
    }

    private Feature<T> duplicateAndRemoveName(Feature<T> feature) {
        return feature.duplicateChangeName("");
    }

    @Generated
    public StringSet getReferencesFeatureListCreator() {
        return this.referencesFeatureListCreator;
    }

    @Generated
    public void setReferencesFeatureListCreator(StringSet referencesFeatureListCreator) {
        this.referencesFeatureListCreator = referencesFeatureListCreator;
    }

    @Generated
    public PermuteProperty<S> getPermutation() {
        return this.permutation;
    }

    @Generated
    public void setPermutation(PermuteProperty<S> permutation) {
        this.permutation = permutation;
    }

    @Generated
    public List<PermuteProperty<S>> getPermutations() {
        return this.permutations;
    }

    @Generated
    public void setPermutations(List<PermuteProperty<S>> permutations) {
        this.permutations = permutations;
    }
}

