/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.object.combine;

import java.util.List;
import lombok.Generated;
import org.anchoranalysis.bean.NamedBean;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.feature.bean.list.FeatureListProvider;
import org.anchoranalysis.feature.energy.EnergyStack;
import org.anchoranalysis.feature.store.NamedFeatureStore;
import org.anchoranalysis.feature.store.NamedFeatureStoreFactory;
import org.anchoranalysis.image.bean.interpolator.Interpolator;
import org.anchoranalysis.image.feature.calculator.FeatureTableCalculator;
import org.anchoranalysis.image.feature.calculator.SingleTableCalculator;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectCollectionFactory;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.feature.bean.object.combine.CombineObjectsForFeatures;
import org.anchoranalysis.plugin.image.feature.bean.object.combine.UniqueIdentifierUtilities;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;

public class EachObjectIndependently
extends CombineObjectsForFeatures<FeatureInputSingleObject> {
    public EachObjectIndependently(Interpolator interpolator) {
        super(interpolator);
    }

    @Override
    public FeatureTableCalculator<FeatureInputSingleObject> createFeatures(List<NamedBean<FeatureListProvider<FeatureInputSingleObject>>> list, NamedFeatureStoreFactory storeFactory, boolean suppressErrors) throws CreateException {
        try {
            return this.createFeatures((NamedFeatureStore<FeatureInputSingleObject>)storeFactory.createNamedFeatureList(list));
        }
        catch (ProvisionFailedException e) {
            throw new CreateException((Throwable)e);
        }
    }

    public FeatureTableCalculator<FeatureInputSingleObject> createFeatures(NamedFeatureStore<FeatureInputSingleObject> features) {
        return new SingleTableCalculator(features);
    }

    @Override
    public String uniqueIdentifierFor(FeatureInputSingleObject input) {
        return UniqueIdentifierUtilities.forObject(input.getObject());
    }

    @Override
    public List<FeatureInputSingleObject> startBatchDeriveInputs(ObjectCollection objects, EnergyStack energyStack, Logger logger) throws CreateException {
        return objects.stream().mapToList(object -> new FeatureInputSingleObject(this.checkObjectInsideScene((ObjectMask)object, energyStack.extent()), energyStack));
    }

    @Override
    public ObjectCollection objectsForThumbnail(FeatureInputSingleObject input) throws CreateException {
        return ObjectCollectionFactory.of((ObjectMask[])new ObjectMask[]{input.getObject()});
    }

    @Override
    protected BoundingBox boundingBoxThatSpansInput(FeatureInputSingleObject input) {
        return input.getObject().boundingBox();
    }

    private ObjectMask checkObjectInsideScene(ObjectMask object, Extent extent) throws CreateException {
        if (!extent.contains(object.boundingBox())) {
            throw new CreateException(String.format("Object is not (perhaps fully) contained inside the scene: %s is not in %s", object.boundingBox(), extent));
        }
        return object;
    }

    @Generated
    public EachObjectIndependently() {
    }
}

