/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.object.pair;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.BeanInstanceMap;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.exception.BeanMisconfiguredException;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.FeatureCalculationInput;
import org.anchoranalysis.feature.calculate.cache.ChildCacheName;
import org.anchoranalysis.feature.calculate.part.CalculationPart;
import org.anchoranalysis.image.feature.bean.object.pair.FeatureDeriveFromPair;
import org.anchoranalysis.image.feature.input.FeatureInputPairObjects;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.feature.bean.morphological.MorphologicalIterations;
import org.anchoranalysis.plugin.image.feature.bean.object.pair.CalculateIntersectionInput;
import org.anchoranalysis.plugin.image.feature.bean.object.pair.CalculatePairIntersectionCommutative;
import org.anchoranalysis.plugin.image.feature.object.calculation.delegate.CalculateInputFromDelegateOption;

public class Intersection
extends FeatureDeriveFromPair {
    @BeanField
    private MorphologicalIterations iterations = new MorphologicalIterations();
    @BeanField
    private double emptyValue = 255.0;

    public void checkMisconfigured(BeanInstanceMap defaultInstances) throws BeanMisconfiguredException {
        super.checkMisconfigured(defaultInstances);
        if (this.iterations.getIterationsDilation() <= 1) {
            throw new BeanMisconfiguredException("iterationsDilation must be >= 1");
        }
    }

    public double calculate(FeatureCalculationInput<FeatureInputPairObjects> input) throws FeatureCalculationException {
        return CalculateInputFromDelegateOption.calc(input, this.createCalculation(input), CalculateIntersectionInput::new, this.getItem(), this.cacheIntersectionName(), this.emptyValue);
    }

    private ChildCacheName cacheIntersectionName() {
        String id = String.format("intersection_%s", this.iterations.uniquelyIdentifyAllProperties());
        return new ChildCacheName(Intersection.class, id);
    }

    private CalculationPart<Optional<ObjectMask>, FeatureInputPairObjects> createCalculation(FeatureCalculationInput<FeatureInputPairObjects> input) {
        return CalculatePairIntersectionCommutative.of(input, CACHE_NAME_FIRST, CACHE_NAME_SECOND, this.iterations);
    }

    @Generated
    public MorphologicalIterations getIterations() {
        return this.iterations;
    }

    @Generated
    public void setIterations(MorphologicalIterations iterations) {
        this.iterations = iterations;
    }

    @Generated
    public double getEmptyValue() {
        return this.emptyValue;
    }

    @Generated
    public void setEmptyValue(double emptyValue) {
        this.emptyValue = emptyValue;
    }
}

