/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.object.pair.overlap;

import java.util.function.IntSupplier;
import lombok.Generated;
import org.anchoranalysis.image.feature.input.FeatureInputPairObjects;

class OverlapRatioUtilities {
    public static double overlapRatioToMaxVolume(FeatureInputPairObjects input) {
        return OverlapRatioUtilities.overlapRatioTo(input, () -> OverlapRatioUtilities.denominatorMaxVolume(input));
    }

    public static double overlapRatioTo(FeatureInputPairObjects input, IntSupplier denominatorFunc) {
        int intersectingVoxels = input.getFirst().countIntersectingVoxels(input.getSecond());
        if (intersectingVoxels == 0) {
            return 0.0;
        }
        return (double)intersectingVoxels / (double)denominatorFunc.getAsInt();
    }

    public static int denominatorMaxVolume(FeatureInputPairObjects input) {
        return Math.max(input.getFirst().numberVoxelsOn(), input.getSecond().numberVoxelsOn());
    }

    @Generated
    private OverlapRatioUtilities() {
    }
}

