/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.object.pair.touching;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.part.CalculationPart;
import org.anchoranalysis.image.feature.input.FeatureInputPairObjects;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;

class CalculateIntersectionOfDilatedBoundingBox
extends CalculationPart<Optional<BoundingBox>, FeatureInputPairObjects> {
    private final boolean do3D;

    protected Optional<BoundingBox> execute(FeatureInputPairObjects input) throws FeatureCalculationException {
        return this.findIntersectionOfDilatedBoundingBox(input.getFirst(), input.getSecond(), input.dimensionsRequired().extent());
    }

    private Optional<BoundingBox> findIntersectionOfDilatedBoundingBox(ObjectMask first, ObjectMask second, Extent extent) {
        BoundingBox boxFirst = this.dilatedBoundingBoxFor(first, extent);
        BoundingBox boxSecond = this.dilatedBoundingBoxFor(second, extent);
        return boxFirst.intersection().withInside(boxSecond, extent);
    }

    private BoundingBox dilatedBoundingBoxFor(ObjectMask object, Extent extent) {
        return object.boundedVoxels().dilate(this.do3D, Optional.of(extent));
    }

    @Generated
    public CalculateIntersectionOfDilatedBoundingBox(boolean do3D) {
        this.do3D = do3D;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculateIntersectionOfDilatedBoundingBox)) {
            return false;
        }
        CalculateIntersectionOfDilatedBoundingBox other = (CalculateIntersectionOfDilatedBoundingBox)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return this.do3D == other.do3D;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalculateIntersectionOfDilatedBoundingBox;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.do3D ? 79 : 97);
        return result;
    }
}

