/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.object.pair.touching;

import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.kernel.ApplyKernel;
import org.anchoranalysis.image.voxel.kernel.KernelApplicationParameters;
import org.anchoranalysis.image.voxel.kernel.count.CountKernel;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.feature.bean.object.pair.touching.RelativeUtilities;
import org.anchoranalysis.plugin.image.feature.bean.object.pair.touching.TouchingVoxels;
import org.anchoranalysis.spatial.box.BoundingBox;

public class HasTouchingVoxels
extends TouchingVoxels {
    @Override
    protected double calculateWithIntersection(ObjectMask first, ObjectMask second, BoundingBox boxIntersect) throws FeatureCalculationException {
        return HasTouchingVoxels.convertToInt(this.calculateHasTouchingRelative(first, RelativeUtilities.relativizeObject(second, first), RelativeUtilities.relativizeBox(boxIntersect, first)));
    }

    private boolean calculateHasTouchingRelative(ObjectMask first, ObjectMask secondRelative, BoundingBox boxIntersectRel) throws FeatureCalculationException {
        CountKernel kernelMatch = this.createCountKernelMask(secondRelative);
        try {
            return ApplyKernel.applyUntilPositive((CountKernel)kernelMatch, (BinaryVoxels)first.binaryVoxels(), (BoundingBox)boxIntersectRel, (KernelApplicationParameters)this.createParameters());
        }
        catch (OperationFailedException e) {
            throw new FeatureCalculationException((Throwable)e);
        }
    }

    private static int convertToInt(boolean b) {
        return b ? 1 : 0;
    }
}

