/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.object.single;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.FeatureCalculationInput;
import org.anchoranalysis.image.feature.bean.object.single.FeatureSingleObject;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.spatial.axis.Axis;
import org.anchoranalysis.spatial.axis.AxisConversionException;
import org.anchoranalysis.spatial.axis.AxisConverter;

public class ArbitraryInsidePoint
extends FeatureSingleObject {
    @BeanField
    private String axis = "x";
    @BeanField
    private double emptyValue = 0.0;

    public ArbitraryInsidePoint(String axis) {
        this.axis = axis;
    }

    public double calculate(FeatureCalculationInput<FeatureInputSingleObject> input) throws FeatureCalculationException {
        try {
            Axis axisObj = AxisConverter.createFromString((String)this.axis);
            Optional arbPoint = ((FeatureInputSingleObject)input.get()).getObject().findArbitraryOnVoxel();
            return arbPoint.map(point -> point.valueByDimension(axisObj)).orElse(this.emptyValue);
        }
        catch (AxisConversionException e) {
            throw new FeatureCalculationException(e.friendlyMessageHierarchy());
        }
    }

    @Generated
    public ArbitraryInsidePoint() {
    }

    @Generated
    public String getAxis() {
        return this.axis;
    }

    @Generated
    public void setAxis(String axis) {
        this.axis = axis;
    }

    @Generated
    public double getEmptyValue() {
        return this.emptyValue;
    }

    @Generated
    public void setEmptyValue(double emptyValue) {
        this.emptyValue = emptyValue;
    }
}

