/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.object.single.boundingbox;

import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.FeatureCalculationInput;
import org.anchoranalysis.image.feature.bean.object.single.FeatureSingleObject;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.spatial.axis.AxisConversionException;
import org.anchoranalysis.spatial.axis.AxisConverter;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

public abstract class BoundingBoxAlongAxisBase
extends FeatureSingleObject {
    @BeanField
    private String axis = "x";

    public double calculate(FeatureCalculationInput<FeatureInputSingleObject> input) throws FeatureCalculationException {
        FeatureInputSingleObject inputSessionless = (FeatureInputSingleObject)input.get();
        ReadableTuple3i point = this.extractTupleForBoundingBox(inputSessionless.getObject().boundingBox());
        return this.calculateAxisValue(point);
    }

    protected abstract ReadableTuple3i extractTupleForBoundingBox(BoundingBox var1);

    public String describeParameters() {
        return String.format("%s", this.axis);
    }

    private double calculateAxisValue(ReadableTuple3i point) throws FeatureCalculationException {
        try {
            return point.valueByDimension(AxisConverter.createFromString((String)this.axis));
        }
        catch (AxisConversionException e) {
            throw new FeatureCalculationException(e.friendlyMessageHierarchy());
        }
    }

    @Generated
    public String getAxis() {
        return this.axis;
    }

    @Generated
    public void setAxis(String axis) {
        this.axis = axis;
    }
}

