/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.object.single.intensity;

import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.FeatureCalculationInput;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.feature.bean.object.single.intensity.FeatureEnergyChannel;
import org.anchoranalysis.plugin.image.intensity.IntensityMeanCalculator;

public class TextureScore
extends FeatureEnergyChannel {
    @BeanField
    private int energyIndexGradient = 1;

    @Override
    protected double calculateForChannel(FeatureCalculationInput<FeatureInputSingleObject> input, Channel channel) throws FeatureCalculationException {
        ObjectMask object = ((FeatureInputSingleObject)input.get()).getObject();
        Channel channelGradient = ((FeatureInputSingleObject)input.get()).getEnergyStackRequired().getChannel(this.energyIndexGradient);
        return TextureScore.scoreFromMeans(IntensityMeanCalculator.calculateMeanIntensityObject((Channel)channel, (ObjectMask)object), IntensityMeanCalculator.calculateMeanIntensityObject((Channel)channelGradient, (ObjectMask)object));
    }

    private static double scoreFromMeans(double meanIntensity, double meanGradientIntensity) {
        double scaleFactor = 128.0 / meanIntensity;
        return scaleFactor * meanGradientIntensity / meanIntensity;
    }

    @Generated
    public int getEnergyIndexGradient() {
        return this.energyIndexGradient;
    }

    @Generated
    public void setEnergyIndexGradient(int energyIndexGradient) {
        this.energyIndexGradient = energyIndexGradient;
    }
}

