/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.object.single.moments;

import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.math.statistics.moment.ImageMoments;
import org.anchoranalysis.plugin.image.feature.bean.object.single.moments.AxisLengthEstimator;
import org.anchoranalysis.plugin.image.feature.bean.object.single.moments.ImageMomentsBase;

public class RatioPrincipalAxisLength
extends ImageMomentsBase {
    @Override
    protected double calculateFromAllMoments(ImageMoments moments) throws FeatureCalculationException {
        moments.removeClosestToUnitZ();
        double moments0 = RatioPrincipalAxisLength.estimateAxisLength(moments, 0);
        double moments1 = RatioPrincipalAxisLength.estimateAxisLength(moments, 1);
        if (moments0 == 0.0 && moments1 == 0.0) {
            return 1.0;
        }
        if (moments0 == 0.0 || moments1 == 0.0) {
            throw new FeatureCalculationException("All moments are 0");
        }
        return moments0 / moments1;
    }

    @Override
    protected String errorMessageIfTooFewPixels() {
        return "Too few voxels to determine principal axes and therefore ratio of principal-axis length";
    }

    private static double estimateAxisLength(ImageMoments moments, int axis) {
        return AxisLengthEstimator.fromNormalizedEigenvalue(moments.get(axis).getEigenvalue());
    }
}

