/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.object.single.shape;

import lombok.Generated;
import org.anchoranalysis.image.voxel.kernel.KernelApplicationParameters;
import org.anchoranalysis.image.voxel.kernel.OutsideKernelPolicy;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.feature.bean.object.single.border.NumberVoxelsAtBorder;

class ShapeRegularityCalculator {
    private static final KernelApplicationParameters OUTLINE_KERNEL_PARAMETERS = new KernelApplicationParameters(OutsideKernelPolicy.AS_OFF, false);

    public static double calculateShapeRegularity(ObjectMask object) {
        double area = object.numberVoxelsOn();
        int perimeter = NumberVoxelsAtBorder.numberBorderPixels(object, OUTLINE_KERNEL_PARAMETERS);
        return ShapeRegularityCalculator.calculateValues(area, perimeter);
    }

    private static double calculateValues(double area, int perimeter) {
        if (perimeter == 0) {
            return 0.0;
        }
        double val = Math.PI * 2 * Math.sqrt(area / Math.PI) / (double)perimeter;
        assert (!Double.isNaN(val));
        return val;
    }

    @Generated
    private ShapeRegularityCalculator() {
    }
}

