/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.object.single.slice;

import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.FeatureCalculationInput;
import org.anchoranalysis.image.core.contour.FindContour;
import org.anchoranalysis.image.feature.bean.object.single.FeatureSingleObject;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.object.ObjectMask;

public class MaximumNumberContourVoxelsOnSlice
extends FeatureSingleObject {
    public double calculate(FeatureCalculationInput<FeatureInputSingleObject> input) throws FeatureCalculationException {
        ObjectMask object = ((FeatureInputSingleObject)input.get()).getObject();
        return MaximumNumberContourVoxelsOnSlice.numberVoxelsOnContour(MaximumNumberContourVoxelsOnSlice.sliceWithMaxNumberVoxels(object));
    }

    private static ObjectMask sliceWithMaxNumberVoxels(ObjectMask object) {
        return object.extractSlice(MaximumNumberContourVoxelsOnSlice.indexOfSliceWithMaxNumberVoxels(object), false);
    }

    private static int numberVoxelsOnContour(ObjectMask obj) {
        return FindContour.createFrom((ObjectMask)obj, (int)1, (boolean)false, (boolean)true).binaryVoxels().countOn();
    }

    private static int countForByteBuffer(UnsignedByteBuffer buffer, byte equalVal) {
        int count = 0;
        while (buffer.hasRemaining()) {
            if (buffer.getRaw() != equalVal) continue;
            ++count;
        }
        return count;
    }

    private static int indexOfSliceWithMaxNumberVoxels(ObjectMask object) {
        int max = 0;
        int ind = 0;
        for (int z = 0; z < object.boundingBox().extent().z(); ++z) {
            UnsignedByteBuffer buffer = object.sliceBufferLocal(z);
            int count = MaximumNumberContourVoxelsOnSlice.countForByteBuffer(buffer, object.binaryValuesByte().getOn());
            if (count <= max) continue;
            max = count;
            ind = z;
        }
        return ind + object.boundingBox().cornerMin().z();
    }
}

