/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.object.single.surface;

import lombok.Generated;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.part.CalculationPart;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.binary.BinaryVoxelsFactory;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesInt;
import org.anchoranalysis.image.voxel.kernel.ApplyKernel;
import org.anchoranalysis.image.voxel.kernel.KernelApplicationParameters;
import org.anchoranalysis.image.voxel.kernel.OutsideKernelPolicy;
import org.anchoranalysis.image.voxel.kernel.count.CountKernel;
import org.anchoranalysis.image.voxel.kernel.count.CountKernelNeighborhood;
import org.anchoranalysis.image.voxel.object.ObjectMask;

class CalculateOutlineNumberVoxelFaces
extends CalculationPart<Integer, FeatureInputSingleObject> {
    private final boolean mip;
    private final boolean suppress3D;

    private static int calculateSurfaceSize(ObjectMask object, Dimensions dimensions, boolean mip, boolean suppress3D) {
        boolean do3D;
        boolean bl = do3D = dimensions.z() > 1 && !suppress3D;
        if (do3D && mip) {
            CountKernelNeighborhood kernel = new CountKernelNeighborhood();
            BinaryVoxels voxelsProjected = BinaryVoxelsFactory.reuseByte((Voxels)object.extract().projectMax(), (BinaryValuesInt)object.binaryValues());
            KernelApplicationParameters parameters = new KernelApplicationParameters(OutsideKernelPolicy.IGNORE_OUTSIDE, false);
            return ApplyKernel.applyForCount((CountKernel)kernel, (BinaryVoxels)voxelsProjected, (KernelApplicationParameters)parameters);
        }
        CountKernelNeighborhood kernel = new CountKernelNeighborhood();
        KernelApplicationParameters parameters = new KernelApplicationParameters(OutsideKernelPolicy.IGNORE_OUTSIDE, do3D);
        return ApplyKernel.applyForCount((CountKernel)kernel, (BinaryVoxels)object.binaryVoxels(), (KernelApplicationParameters)parameters);
    }

    protected Integer execute(FeatureInputSingleObject input) throws FeatureCalculationException {
        return CalculateOutlineNumberVoxelFaces.calculateSurfaceSize(input.getObject(), input.dimensionsRequired(), this.mip, this.suppress3D);
    }

    @Generated
    public CalculateOutlineNumberVoxelFaces(boolean mip, boolean suppress3D) {
        this.mip = mip;
        this.suppress3D = suppress3D;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculateOutlineNumberVoxelFaces)) {
            return false;
        }
        CalculateOutlineNumberVoxelFaces other = (CalculateOutlineNumberVoxelFaces)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.mip != other.mip) {
            return false;
        }
        return this.suppress3D == other.suppress3D;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalculateOutlineNumberVoxelFaces;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.mip ? 79 : 97);
        result = result * 59 + (this.suppress3D ? 79 : 97);
        return result;
    }
}

