/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.object.single.surface;

import lombok.Generated;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.part.CalculationPart;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.kernel.ApplyKernel;
import org.anchoranalysis.image.voxel.kernel.BinaryKernel;
import org.anchoranalysis.image.voxel.kernel.KernelApplicationParameters;
import org.anchoranalysis.image.voxel.kernel.OutsideKernelPolicy;
import org.anchoranalysis.image.voxel.kernel.outline.OutlineKernel;
import org.anchoranalysis.image.voxel.object.ObjectMask;

class CalculateOutlineNumberVoxels
extends CalculationPart<Integer, FeatureInputSingleObject> {
    private boolean mip;
    private boolean suppress3D;

    protected Integer execute(FeatureInputSingleObject input) throws FeatureCalculationException {
        return CalculateOutlineNumberVoxels.calculateSurfaceSize(input.getObject(), input.dimensionsRequired(), this.mip, this.suppress3D);
    }

    private static int calculateSurfaceSize(ObjectMask object, Dimensions dimensions, boolean mip, boolean suppress3D) {
        boolean do3D;
        boolean bl = do3D = dimensions.z() > 1 && !suppress3D;
        if (do3D && mip) {
            return CalculateOutlineNumberVoxels.applyForCount((BinaryVoxels<UnsignedByteBuffer>)object.flattenZ().binaryVoxels(), false);
        }
        return CalculateOutlineNumberVoxels.applyForCount((BinaryVoxels<UnsignedByteBuffer>)object.binaryVoxels(), do3D);
    }

    private static int applyForCount(BinaryVoxels<UnsignedByteBuffer> voxels, boolean do3D) {
        KernelApplicationParameters parameters = new KernelApplicationParameters(OutsideKernelPolicy.AS_OFF, do3D);
        return ApplyKernel.applyForCount((BinaryKernel)new OutlineKernel(), voxels, (KernelApplicationParameters)parameters);
    }

    @Generated
    public CalculateOutlineNumberVoxels(boolean mip, boolean suppress3D) {
        this.mip = mip;
        this.suppress3D = suppress3D;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculateOutlineNumberVoxels)) {
            return false;
        }
        CalculateOutlineNumberVoxels other = (CalculateOutlineNumberVoxels)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.mip != other.mip) {
            return false;
        }
        return this.suppress3D == other.suppress3D;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalculateOutlineNumberVoxels;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.mip ? 79 : 97);
        result = result * 59 + (this.suppress3D ? 79 : 97);
        return result;
    }
}

