/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.feature.bean.score;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.value.Dictionary;
import org.anchoranalysis.image.bean.threshold.CalculateLevel;
import org.anchoranalysis.math.histogram.Histogram;
import org.anchoranalysis.plugin.image.feature.bean.score.SingleChannel;

public abstract class CalculateLevelBase
extends SingleChannel {
    @BeanField
    private CalculateLevel calculateLevel;
    @BeanField
    private int histogramChannelIndex = 0;
    private int level;

    public void initialize(List<Histogram> histograms, Optional<Dictionary> dictionary) throws InitializeException {
        try {
            Histogram histogram = histograms.get(this.histogramChannelIndex);
            this.level = this.calculateLevel.calculateLevel(histogram);
            this.beforeCalcSetup(histogram, this.level);
        }
        catch (OperationFailedException e) {
            throw new InitializeException((Throwable)e);
        }
    }

    @Override
    protected double deriveScoreFromVoxel(int voxelIntensity) {
        return this.calculateForVoxel(voxelIntensity, this.level);
    }

    protected abstract void beforeCalcSetup(Histogram var1, int var2) throws OperationFailedException;

    protected abstract double calculateForVoxel(int var1, int var2);

    @Generated
    public CalculateLevel getCalculateLevel() {
        return this.calculateLevel;
    }

    @Generated
    public void setCalculateLevel(CalculateLevel calculateLevel) {
        this.calculateLevel = calculateLevel;
    }

    @Generated
    public int getHistogramChannelIndex() {
        return this.histogramChannelIndex;
    }

    @Generated
    public void setHistogramChannelIndex(int histogramChannelIndex) {
        this.histogramChannelIndex = histogramChannelIndex;
    }
}

